###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################


use Getopt::Std;

getopts('c:lfr:');
if (defined($opt_c)) {
  $mincount = $opt_c;
} else {
  $mincount = 0.0;
}
if (defined($opt_l)) {
  $longout = $opt_l;
} else {
  $longout = 0;
}
if (defined($opt_f)) {
  $rawfreq = $opt_f;
} else {
  $rawfreq = 0;
}
if (defined($opt_r)) {          # don't do blind cutoffs; replace w/ symb
  $replace = $opt_r;
  $newcutoff = 1;
} else {
  $newcutoff = 0;
}

print stderr "mincount = $mincount\n";

# for the replace version
sub replace {
  @args = @_;
  $lowct = $args[0];
	
  # get the substitute string ready
  @parts = split(/[ :;\{\}\/,~\(\)\<\>\[\]]+/,$lowct);
  @delims = $lowct =~ /([ :;\{\}\/,~\(\)\<\>\[\]]+)/g;
  @replacers = ( ($replace) x ($#parts+1));
  @combined = map { $replacers[$_], $delims[$_] } 
    0 .. ($#replacers > $#delims ? $#replacers : $#delims);
  $r = join("",@combined);
  return $r;
}

while ( <> ) {
  chomp;

  if ( $_ =~ /(.*) : (.*) = (.*)/ ) {
    if (!exists($Cond{$1})) {
      $Cond{$1} = 0.0;
    }
    if (!exists($Genv{$2})) {
      $Genv{$2} = 0.0;
    }
    if (!exists($Val{$1}{$2})) {
      $Val{$1}{$2} = 0.0;
    }
    $Cond{$1} += $3;
    @targs = split(/ +/,$2);
    foreach $t (@targs) {
      $Genv{$t} += $3;
    }
    $Val{$1}{$2} += $3;
  } elsif ( $_ =~ /(.*) : (.*)/ ) {
    $Cond{$1}++;
    @targs = split(/ +/,$2);
    foreach $t (@targs) {
      $Genv{$t}++;
    }
    $Val{$1}{$2}++;
    #print "$1|$2|\n";
  }
}

# don't replace, do blind cutoffs
if ($newcutoff==0) {

  ## Special case for prior distribution:
  foreach $c (keys %Cond) {
    if (not ($c =~ /^[^ ]$/)) {
      next;
    }
    foreach $v (keys %{$Val{$c}}) {
      if ($Val{$c}{$v} < $mincount) {
        $Cond{$c} -= $Val{$c}{$v};
        delete $Val{$c}{$v};
      }
    }
  }

}

# replace whole low counts
else {

  # make a pass to replace low counts
  if ($mincount>0) {

    foreach $lhs (sort keys %Val) {

      # check on lhs for replaceables
      my @newlwords;
      @lwords = split(/ +/,$lhs);
      my $ctr=0; my $lflag; 
      foreach $lword (@lwords) {
        if ( ($Genv{$lword}<$mincount) && ($lword ne replace($lword)) && $ctr!=0) {
          $lflag = 1;
          push( @newlwords, replace($lword) );
        } else {
          push( @newlwords, $lword );
        }
        $ctr++;
      }
      $newlhs = join(' ',@newlwords);

      # check on rhs 
      foreach $rhs (sort keys %{$Val{$lhs}}) {
        my @newrwords; my $rflag;
        @rwords = split(/ +/,$rhs);
        foreach $rword (@rwords) {
          if ( $Genv{$rword}<$mincount && $rword ne replace($rword) ) {
            $rflag = 1;
            push( @newrwords, replace($rword) );
            $Genv{$rhs}
          } else {
            push( @newrwords, $rword );
          }
        }
        $newrhs = join(' ',@newrwords);

        # replace rhs targets
        if ($lflag && $rflag) {
          $Val{$newlhs}{$newrhs} += $Val{$lhs}{$rhs};
          $Cond{$newlhs} += $Val{$lhs}{$rhs};
          delete $Val{$lhs}{$rhs};
        } elsif ($rflag) {
          #		print " newrhs $newrhs from $lhs -> $rhs\n";
          $Val{$newlhs}{$newrhs} += $Val{$lhs}{$rhs};
          delete $Val{$lhs}{$rhs};
        } elsif ($lflag) {
          #		print " newlhs $newlhs from $lhs\n";
          $Val{$newlhs}{$rhs} += $Val{$lhs}{$rhs};
          $Cond{$newlhs} += $Val{$lhs}{$rhs};
          delete $Val{$lhs}{$rhs};
        }
      }
    }
  }


}



foreach $c (sort keys %Cond) {
  if ( $Cond{$c} >= $mincount ) {
    foreach $v (sort keys %{$Val{$c}}) {
      #print STDERR "count = $Cond{$c}\n";
      if ($Cond{$c} == 0.0) {
        print STDERR "Divide by zero encountered with:\n cond=$c\n";
        last;
      }
      print "$c : $v = ";
      my $valtoprint = $rawfreq ? $Val{$c}{$v} : $Val{$c}{$v}/$Cond{$c};
      if (defined($opt_l)) {
        printf( "%.12f\n", $valtoprint);
      } elsif (!defined($opt_f)) {
        printf( "%.8f\n", $valtoprint);
      } else {
        print "$valtoprint\n";
      }
    }
  }
}
