###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################

use Getopt::Std;

getopts("d");

$DEBUG = 0;
if ($opt_d) {
  $DEBUG = 1;
}

sub debug {
  if ($DEBUG) {
    $msg = $_[1];
    print stderr $_[0] , " " , $msg, "\n";
  }
}

## for each tree...
while ( <> ) {
  ## mark top-level constituent as current...
  s/^ *\((.*)\) *$/{\1}/;
  ## mark all other constituents as internal...
  s/\(/\[/g;
  s/\)/\]/g;
  ## for each constituent...
  while ( $_ =~ /{/ ) {
    ## mark all children of current...
    for ( $i=index($_,'{'),$d=0; $i<index($_,'}'); $i++ ) {
      if ( substr($_,$i,1)eq'[' ) { if($d==0){substr($_,$i,1)='<';} $d++; }
      if ( substr($_,$i,1)eq']' ) { $d--; if($d==0){substr($_,$i,1)='>';} }
    }
    #################### ADD SED RULES HERE: apply rules to angles (children) within braces (consituent)...
    debug(++$step, "   $_");

    # pass time-np tags down to each head
    while ( s/{([^ ]*)(-tmp)(.*)<(?![^ ]*-t)([^ ]*-h[^ ]*)(.*)>(.*)}/{\1\2\3<\4\2\5>\6}/ ) {}

    # pass subcat tags down to each head
    while ( s/{(((?!-b)[^ ])*)((-b[^- ]+)+)(.*)<(?![^ ]*-b)([^ ]*-h[^ ]*)(.*)>(.*)}/{\1\3\5<\6\3\7>\8}/ ) {}

    # identify arguments and add subcat tags
    s/{(NP|NN)(.*)<(DT[^ ]*)([^>]*)> *<(NN|JJ)([- ][^>]*)> *}/{\1\2<\3-b\5\4> <\5\6>}/;
    s/{(NP|NN)(.*)<(NN[^ ]*)([^>]*)> *<(Sproto|Sto|SBARthat|NP|ADJP|PPof)([- ][^>]*)> *}/{\1\2<\3-b\5\4> <\5\6>}/;
    s/{(PP|SBAR)(.*)<(IN[^ ]*)([^>]*)> *<(S(?!-adv)|NP|ADJP)([- ][^>]*)> *}/{\1\2<\3-b\5\4> <\5\6>}/;
    s/{(VP|VB)(.*)<(VB[^ ]*)([^>]*)> *<(Sproto(?!-adv)|Sto(?!-adv)|SBARthat|Sprovbn(?!-adv)|Sprovbg(?!-adv)|S(?!-adv)|NP|ADJP|VP|PRT)([- ][^>]*)> *}/{\1\2<\3-b\5\4> <\5\6>}/;

    ####################
    ## mark current as external...
    s/{(.*?)}/\(\1\)/;
    ## mark first unexpanded child as current...
    s/<(.*?)>/{\1}/;
  }
  # output
  print $_;
}
