###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################


gold = $*[0]
hyp = $*[1]

#puts "Files input are #{file1} and #{file2}"
gf = File.open(gold)
hf = File.open(hyp)
line_num = 0

## Precision: percent of each arg (e.g. ARG0, ARG1,...) in hyp correctly recognized 
# (prec_points / 1_predict)
## Recall: Percent of actual arg (e.g. ARG0, ARG1, ...) found
# (prec_points / 1_actual)

prec_points = Hash.new(0) 
predict_ones = Hash.new(0)
actual_ones = Hash.new(0)
correct = Hash.new(0)
total = Hash.new(0)

while(line1=gf.gets)
  line_num += 1
  line2 = hf.gets
  if not line2
    $stderr.puts "WARNING: Hypoths file was smaller than gold file"
    break
  end
  goldList = line1.split(' ')
  hypList = line2.split(' ')
  if goldList.size != hypList.size
    $stderr.puts "Length mismatch: #{goldList.size}|#{hypList.size} on line #{line_num}"
  end
  
  goldList.each_index{ |i|
    gLabel = goldList[i]
    hLabel = hypList[i]
    if hLabel == nil
       break
    elsif gLabel == hLabel
      prec_points[gLabel] += 1
      predict_ones[gLabel] += 1
      actual_ones[gLabel] += 1
      correct[gLabel] += 1
    else
      actual_ones[gLabel] += 1
      predict_ones[hLabel] += 1
    end
    total[gLabel] += 1
  }
  
#  puts "Line: #{line_num}"
#  puts "prec_points = #{prec_points}"
#  puts "predict_ones = #{predict_ones}"
#  puts "actual_ones = #{actual_ones}"
#  puts "correct = #{correct}"
  
end

precision = Hash.new(0)
recall = Hash.new(0)
fscore = Hash.new(0)
accuracy = Hash.new(0)

actual_ones.keys.each{ |k|
  precision[k] = predict_ones[k] == 0 ? 0.0 : prec_points[k].to_f / predict_ones[k].to_f
  recall[k] = prec_points[k].to_f / actual_ones[k].to_f
  fscore[k] = precision[k] + recall[k] == 0 ? 0.0 : 2.0 * recall[k] * precision[k] / (precision[k] + recall[k])
  accuracy[k] = correct[k].to_f / total[k].to_f
}

puts "Results:\n"
actual_ones.keys.sort.each{ |k|
  puts "  #{k} Recall:    #{recall[k]}"
  puts "  #{k} Precision: #{precision[k]}"
  puts "  #{k} F-score:   #{fscore[k]}"
#  puts "  #{k} Accuracy:  #{accuracy[k]}"
  puts " "
}

allLabelTotal = 0
allLabelRecall = 0
allLabelPrecision = 0

puts " Label & Recall & Precision & F-score \\\\"
actual_ones.keys.sort.each{ |k|
  puts "  #{k} &  #{recall[k]} & #{precision[k]} &  #{fscore[k]} \\\\"
  
  allLabelTotal += total[k].to_f
  allLabelRecall += (total[k].to_f * recall[k].to_f)      #unless recall[k].nan? 
  allLabelPrecision += (total[k].to_f * precision[k].to_f)     #unless precision[k].nan? 
}

allLabelRecall = allLabelRecall.to_f / allLabelTotal.to_f
allLabelPrecision = allLabelPrecision.to_f / allLabelTotal.to_f
allLabelFscore = allLabelPrecision + allLabelRecall == 0 ? 0.0 : 2.0 * allLabelRecall * allLabelPrecision / (allLabelPrecision + allLabelRecall)

puts "Overall & #{allLabelRecall} & #{allLabelPrecision} & #{allLabelFscore}"
