#!/usr/bin/ruby


require "scripts/umnlp.rb"

$error = false
$line = ""

class Tree
    # return the left most child which is not CC, or any punctuation node
  def getLeftMostChild()
    @children.each { |child|
      if child.head != "CC" && child.head != "," && child.head != ":" && child.head != "``" && child.head != "''" 
        return child
      end
    }
    return nil
  end
  
  def getLeftMostLeaf()
    if self.children.size == 0
      return self
    end
    return self.children[0].getLeftMostLeaf()
  end
  
  def flipIfPatternFound(feats)
    wordAndLabel = self.head.split(":")
    if wordAndLabel[1] == "NULL"
      if wordAndLabel[0] == "am" || wordAndLabel[0] == "are" || wordAndLabel[0] == "is" || wordAndLabel[0] == "'m" || wordAndLabel[0] == "'re" || wordAndLabel[0] == "'s" || wordAndLabel[0] == "being" ||\
        wordAndLabel[0] == "was" || wordAndLabel[0] == "were" || wordAndLabel[0] == "been" || wordAndLabel[0] == "be" || wordAndLabel[0] == "ought" || wordAndLabel[0] == "to" || \
        wordAndLabel[0] == "do" || wordAndLabel[0] == "does" || wordAndLabel[0] == "did" || wordAndLabel[0] == "done" ||
        wordAndLabel[0] == "have" || wordAndLabel[0] == "has" || wordAndLabel[0] == "had" || wordAndLabel[0] == "'ve" || wordAndLabel[0] == "'d"
        if feats =~ /P$/
          self.head = wordAndLabel[0] + ":ARGM-AP"
        else
          self.head = wordAndLabel[0] + ":ARGM-AA"
        end
      end
      
    end
  end
  
  def checkFlipNULLtoAUX(vpParent, child, feats)
    while ( vpParent != nil && vpParent.head =~ /VP/ )
      leftMostChild = vpParent.getLeftMostChild()
      if leftMostChild != child && leftMostChild != nil
        leftMostLeaf = leftMostChild.getLeftMostLeaf()        
        leftMostLeaf.flipIfPatternFound(feats)
      end
      child = vpParent
      vpParent = vpParent.parent
      if vpParent != nil && vpParent.head == "PRN" # saw interim PRN on the VP chain
        child = vpParent
        vpParent = vpParent.parent
      end
    end
  end
  

    def findRel()
    if @head =~ /:REL\-/
      feats = @head[-5,5]
      # locate the first subtree of VPxxx covering the rel
      curChild = @parent
      vpParent = @parent.parent
      while vpParent != nil && vpParent.head !~ /VP/
        curChild = vpParent
        vpParent = vpParent.parent
      end
      if vpParent != nil && vpParent.head =~ /VP/
        checkFlipNULLtoAUX(vpParent, curChild, feats)
      else
        $stderr.print "No VP above REL in sentence: ", $line, "\n"
      end
      return @parent
    elsif @children.size == 0
      return nil
    else
      @children.each { |child|
        tmp = child.findRel()
        if tmp != nil 
          return tmp
        end
      }
      return nil
    end
  end

end


#hack to run in ide
#f = File.open("test11") or die "Unable to open file..."

#$features = IO.readlines("srcmodel/features.from.prop.txt")

$relParent = Hash.new(0) # hash returns a value of zero if key not present
$lineNum = 0
while($line = gets)
#File.open("genmodel/all.wsjpu.bintrees.no.arg-aux").each_line do |$line| 
  
  t = Tree.new($line)
  t.findRel()
  print t.to_s, "\n"
  
  $lineNum += 1
end

$stderr.print "rels that have parent not known yet what to do with\n"
$relParent.sort{|a,b| b[1] <=> a[1]}.each {|x| $stderr.print "#{x[0]} : #{x[1]} instances\n"} 

def notWork() 
  # negations
  $line.gsub!( /#do:NULL\)\) \(rb RB#n't:ARGM-NEG\)\)/, "#do:ARGM-AUX)) (rb RB#n't:ARGM-NEG))")
  $line.gsub!( /#do:NULL\)\) \(rb RB#not:ARGM-NEG\)\)/, "#do:ARGM-AUX)) (rb RB#not:ARGM-NEG))")
  $line.gsub!( /#does:NULL\)\) \(rb RB#n't:ARGM-NEG\)\)/, "#does:ARGM-AUX)) (rb RB#n't:ARGM-NEG))")
  $line.gsub!( /#does:NULL\)\) \(rb RB#not:ARGM-NEG\)\)/, "#does:ARGM-AUX)) (rb RB#not:ARGM-NEG))")
  $line.gsub!( /#did:NULL\)\) \(rb RB#n't:ARGM-NEG\)\)/, "#did:ARGM-AUX)) (rb RB#n't:ARGM-NEG))")
  $line.gsub!( /#did:NULL\)\) \(rb RB#not:ARGM-NEG\)\)/, "#did:ARGM-AUX)) (rb RB#not:ARGM-NEG))")

  $line.gsub!( /#are:NULL\)\) \(rb RB#n't:ARGM-NEG\)\)/, "#are:ARGM-AUX)) (rb RB#n't:ARGM-NEG))")
  $line.gsub!( /#are:NULL\)\) \(rb RB#not:ARGM-NEG\)\)/, "#are:ARGM-AUX)) (rb RB#not:ARGM-NEG))")
  $line.gsub!( /#is:NULL\)\) \(rb RB#n't:ARGM-NEG\)\)/, "#is:ARGM-AUX)) (rb RB#n't:ARGM-NEG))")
  $line.gsub!( /#is:NULL\)\) \(rb RB#not:ARGM-NEG\)\)/, "#is:ARGM-AUX)) (rb RB#not:ARGM-NEG))")
  $line.gsub!( /#was:NULL\)\) \(rb RB#n't:ARGM-NEG\)\)/, "#was:ARGM-AUX)) (rb RB#n't:ARGM-NEG))")
  $line.gsub!( /#was:NULL\)\) \(rb RB#not:ARGM-NEG\)\)/, "#was:ARGM-AUX)) (rb RB#not:ARGM-NEG))")
  $line.gsub!( /#were:NULL\)\) \(rb RB#n't:ARGM-NEG\)\)/, "#were:ARGM-AUX)) (rb RB#n't:ARGM-NEG))")
  $line.gsub!( /#were:NULL\)\) \(rb RB#not:ARGM-NEG\)\)/, "#were:ARGM-AUX)) (rb RB#not:ARGM-NEG))")

  $line.gsub!( /#have:NULL\)\) \(rb RB#n't:ARGM-NEG\)\)/, "#hare:ARGM-AUX)) (rb RB#n't:ARGM-NEG))")
  $line.gsub!( /#have:NULL\)\) \(rb RB#not:ARGM-NEG\)\)/, "#hare:ARGM-AUX)) (rb RB#not:ARGM-NEG))")
  $line.gsub!( /#has:NULL\)\) \(rb RB#n't:ARGM-NEG\)\)/, "#has:ARGM-AUX)) (rb RB#n't:ARGM-NEG))")
  $line.gsub!( /#has:NULL\)\) \(rb RB#not:ARGM-NEG\)\)/, "#has:ARGM-AUX)) (rb RB#not:ARGM-NEG))")
  $line.gsub!( /#had:NULL\)\) \(rb RB#n't:ARGM-NEG\)\)/, "#had:ARGM-AUX)) (rb RB#n't:ARGM-NEG))")
  $line.gsub!( /#had:NULL\)\) \(rb RB#not:ARGM-NEG\)\)/, "#had:ARGM-AUX)) (rb RB#not:ARGM-NEG))")

# affirmation
# when do/does/did have a rel followed immediattely
  $line.gsub!( /#do:NULL\)\) ([^#]*)#([^#]*):REL/, '#do:ARGM-AUX)) \1#\2:REL')
  $line.gsub!( /#does:NULL\)\) ([^#]*)#([^#]*):REL/, '#does:ARGM-AUX)) \1#\2:REL')
  $line.gsub!( /#did:NULL\)\) ([^#]*)#([^#]*):REL/, '#did:ARGM-AUX)) \1#\2:REL')
  
# only one word between do/does/did and the rel. 
#E.g. [did indeed have], [did you see], they [did four-day matched] sales
#what about "it acts ... as it [did to arrest] the 1985 decline ..." ??? Not allow "to" in the middle?
#it [did , shaking] the apple establishment to its roots ???
#the one thing mr philips [does have going] for him ... ??? 
  $line.gsub!( /#do:NULL\)\) ([^#]*)#([^#]*)#([^#]*):REL/, '#do:ARGM-AUX)) \1#\2#\3:REL')
  $line.gsub!( /#does:NULL\)\) ([^#]*)#([^#]*)#([^#]*):REL/, '#does:ARGM-AUX)) \1#\2#\3:REL')
  $line.gsub!( /#did:NULL\)\) ([^#]*)#([^#]*)#([^#]*):REL/, '#did:ARGM-AUX)) \1#\2#\3:REL')
  
# how about 2 words between do/does/did and the rel
# E.g. "how soon [does this disk-drive come] ...", [did once awhile happen]
# This won't seem to work: E.g. "I [did , he said] .  
  
  print $line
end