###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################


require 'scripts/umnlp.rb'

$unfHash = Hash.new

class Tree

  def printSpecialRules
    if @children.size == 0
      return
    end
    
    if not @head =~ /UNF/
      key = @head.sub(/^([A-Z$]+).*$/, '\1')
      @children.each_index{ |i|
        if i+1 == @children.size
          break
        end
        key += " #{@children[i].head.sub(/^([A-Z$]+).*$/, '\1')}"
      }
      #$stderr.puts "My key is: #{key}"
      if $unfHash.has_key?(key)
        puts "UN #{key} : #{@children.last.head.sub(/^([A-Z$]+).*/, '\1')}"
      end
      
      puts "RC #{head.sub(/^([A-Z$]+).*$/, '\1')} : #{@children.last.head.sub(/^([A-Z$]+).*/, '\1')}"
    end
    
    @children.each{ |child|
      child.printSpecialRules
    }
  end
  
  #def loadUnfs
  #  $unfHash.put
  #end
end


while(line = gets)

  if (line =~ /^UN (.*)$/)
    $unfHash[$1] = 1
  else
    t = Tree.new(line)
    t.printSpecialRules
  end

end

  