///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. //
//                                                                           //
//    ModelBlocks is free software: you can redistribute it and/or modify    //
//    it under the terms of the GNU General Public License as published by   //
//    the Free Software Foundation, either version 3 of the License, or      //
//    (at your option) any later version.                                    //
//                                                                           //
//    ModelBlocks is distributed in the hope that it will be useful,         //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          //
//    GNU General Public License for more details.                           //
//                                                                           //
//    You should have received a copy of the GNU General Public License      //
//    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include "nl-cpt.h"
#include "nl-dtree.h"
#include "TextObsVars.h"

class XModel {

 private:

  // Data members...
  HidVarCPT2DModel<P,G,Prob>      modPgivG;
  TrainableDTree2DModel<P,X,Prob> modPgivXdt;
  RandAccCPT2DModel<P,W,Prob>     modPgivW;
  RandAccCPT1DModel<P,Prob>       modP;
  RandAccCPT1DModel<W,Prob>       modW;
  RandAccCPT2DModel<W,Rel,LogProb> modConj;
 
 public:

  typedef X RandVarType;

  // Extraction methods...
  LogProb getProb ( const X& x, const SCRA& s ) const {
    G c = G(s.first);
    Prob pr=0.0;
    W w(x);
//		cerr << "XModel:: s = " << s << endl;
    if ( s.fourth.getString().find("REL") != string::npos) {
//		  lp = modConj.getProb(o.getW(), g.second);
        pr += modConj.getProb(x, s.third).toProb();
			//cerr << "TextObsModel::getProb() -- in REL case and w = " << w << ", pr = " << pr << endl;
    } else if ( modW.contains(w) ) {
      for ( P::ArrayIterator<Prob> p = modPgivG.begin(c); !p.end(); ++p ) {
				if(modP.getProb(p) > 0.0){
						Prob prob = modPgivG.getProb(p,c) * modPgivW.getProb(p,w) * LogProb(-1000).toProb() / modP.getProb(p);
						//cerr << "x = " << x << ", p = " << p << ", c = " << c << "prob =" << prob << endl;
						pr += prob; //modPgivG.getProb(p,c) * modPgivW.getProb(p,w) * LogProb(-1000).toProb() / modP.getProb(p);
				}
      }
    } else {
      for ( P::ArrayIterator<Prob> p = modPgivG.begin(c); !p.end(); ++p ) {
        pr += modPgivG.getProb(p,c) * modPgivXdt.getProb(p,x) * LogProb(-1000).toProb() / modP.getProb(p);
      }
    }
    return LogProb(pr);
  }

  // Input/output methods...
  friend pair<StringInput,XModel*> operator>> ( StringInput si, XModel& m ) { return pair<StringInput,XModel*>(si,&m); }
  friend StringInput operator>> ( pair<StringInput,XModel*> si_m, const char* psD ) {
    StringInput si;
    return ( (si=si_m.first>>"Pc "  >>si_m.second->modPgivG  >>psD)!=NULL ||
             (si=si_m.first>>"W "   >>si_m.second->modW      >>psD)!=NULL ||
             (si=si_m.first>>"Pw "  >>si_m.second->modPgivW  >>psD)!=NULL ||
             (si=si_m.first>>"PwDT ">>si_m.second->modPgivXdt>>psD)!=NULL ||
             (si=si_m.first>>"Cj "  >>si_m.second->modConj   >>psD)!=NULL ||
             (si=si_m.first>>"P "   >>si_m.second->modP      >>psD)!=NULL ) ? si : StringInput(NULL);
  }
};

