///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. //
//                                                                           //
//    ModelBlocks is free software: you can redistribute it and/or modify    //
//    it under the terms of the GNU General Public License as published by   //
//    the Free Software Foundation, either version 3 of the License, or      //
//    (at your option) any later version.                                    //
//                                                                           //
//    ModelBlocks is distributed in the hope that it will be useful,         //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          //
//    GNU General Public License for more details.                           //
//                                                                           //
//    You should have received a copy of the GNU General Public License      //
//    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include "nl-cpt.h"

char psX[] = "";
char psSlash[] = "/";
char psComma[] = ",";
char psSemi[] = ";";
char psSemiSemi[] = ";;";
char psDashDiamondDash[] = "-<>-";
char psTilde[] = "~";
//char psBar[]="|";
//char psOpenBrace[]="{";
//char psCloseBrace[]="}";
char psLangle[] = "<";
char psRangle[] = ">";
char psLbrack[] = "[";
char psRbrack[] = "]";

//const char* BEG_STATE = "S/FAKE;fake/fake;-/-;-/-;-;null;--";       //"S/end;-/-;-/-;-/-;-;null;-";
//const char* END_STATE = "S/end;-/-;-/-;-/-;-;null;-";

//const char* BEG_STATE = "S/FAKE;fake/fake;-/-;-/-;-;";       //"S/end;-/-;-/-;-/-;-;null;-";
//const char* END_STATE = "S/end;-/-;-/-;-/-;-;";

const char* BEG_STATE = "S/end;-/-;-/-;-/-;-;-;";       //"S/end;-/-;-/-;-/-;-;null;-";
const char* END_STATE = "S/end;-/-;-/-;-/-;-;-;";

////////////////////////////////////////////////////////////////////////////////
//
//  Random Variables
//
////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////// Simple Variables

//// D: depth (input only, to HHMM models)...
DiscreteDomain<char> domD;
//typedef DiscreteDomainRV<char,domD> D;
class D: public DiscreteDomainRV<char, domD> {
public:
	D() :
		DiscreteDomainRV<char, domD> () {
	}
	D(int i) :
		DiscreteDomainRV<char, domD> (i) {
	}
	D(const char* ps) :
		DiscreteDomainRV<char, domD> (ps) {
	}
};
const D D_0("0");
const D D_1("1");
const D D_2("2");
const D D_3("3");
const D D_4("4");
const D D_5("5");

//// B: boolean
DiscreteDomain<char> domB;
//typedef DiscreteDomainRV<char,domB> B;
class B: public DiscreteDomainRV<char, domB> {
public:
	B() :
		DiscreteDomainRV<char, domB> () {
	}
	B(const char* ps) :
		DiscreteDomainRV<char, domB> (ps) {
	}
};
const B B_0("0");
const B B_1("1");

//// Arg: Semantic argument
DiscreteDomain<int> domArg;
class Arg: public DiscreteDomainRV<int, domArg> {
private:
	static SimpleHash<Arg, B> hToRel;
	void calcHToRel(string s) {
		if (!hToRel.contains(*this)) {
			hToRel.set(*this) = (s.find("REL-", 0) != string::npos) ? B_1 : B_0;
		}
	}
public:
	Arg() :
		DiscreteDomainRV<int, domArg> () {
	}
	Arg(const DiscreteDomainRV<int, domArg>& rv) :
		DiscreteDomainRV<int, domArg> (rv) {
	}
	Arg(const char* ps) :
		DiscreteDomainRV<int, domArg> (ps) {
		calcHToRel(ps);
	}
	B getRel() const {
		return hToRel.get(*this);
	}
	friend pair<StringInput, Arg*> operator>>(StringInput si, Arg& m) {
		return pair<StringInput, Arg*> (si, &m);
	}
	friend StringInput operator>>(pair<StringInput, Arg*> si_m, const char* psD) {
		if (si_m.first == NULL)
			return NULL;
		StringInput si = si_m.first
				>> (DiscreteDomainRV<int, domArg>&) *si_m.second >> psD;
		si_m.second->calcHToRel(si_m.second->getString());
		return si;
	}
};
SimpleHash<Arg, B> Arg::hToRel;
const Arg ARG_BOT("-");

//// Rel: semantic rel, the frameset of the predicate, e.g. sell.01
DiscreteDomain<int> domRel;
class Rel: public DiscreteDomainRV<int, domRel> {
public:
	Rel() :
		DiscreteDomainRV<int, domRel> () {
	}
	Rel(const DiscreteDomainRV<int, domRel>& rv) :
		DiscreteDomainRV<int, domRel> (rv) {
	}
	Rel(const char* ps) :
		DiscreteDomainRV<int, domRel> (ps) {
	}
	friend pair<StringInput, Rel*> operator>>(StringInput si, Rel& m) {
		return pair<StringInput, Rel*> (si, &m);
	}
	friend StringInput operator>>(pair<StringInput, Rel*> si_m, const char* psD) {
		if (si_m.first == NULL)
			return NULL;
		StringInput si = si_m.first
				>> (DiscreteDomainRV<int, domRel>&) *si_m.second >> psD;
		return si;
	}
};

//// Cluster: could be any way of clustering a series of Args, e.g. ARG0-ARG1-REL
DiscreteDomain<int> domCluster;
class Cluster: public DiscreteDomainRV<int, domCluster> {
public:
	Cluster() :
	DiscreteDomainRV<int, domCluster> () {
	}
	Cluster(const DiscreteDomainRV<int, domCluster>& rv) :
	DiscreteDomainRV<int, domCluster> (rv) {
	}
	Cluster(const char* ps) :
	DiscreteDomainRV<int, domCluster> (ps) {
	}
	friend pair<StringInput, Cluster*> operator>>(StringInput si, Cluster& m) {
		return pair<StringInput, Cluster*> (si, &m);
	}
	friend StringInput operator>>(pair<StringInput, Cluster*> si_m, const char* psD) {
		if (si_m.first == NULL)
			return NULL;
		StringInput si = si_m.first
		>> (DiscreteDomainRV<int, domCluster>&) *si_m.second >> psD;
		return si;
	}
};
const Cluster CLUSTER_START("-");

//// G: constituent category...
DiscreteDomain<int> domG;
//typedef DiscreteDomainRV<int,domG> G;
class G: public DiscreteDomainRV<int, domG> {
private:
	static SimpleHash<G, B> hToTerm;
	void calcDetModels(string s) {
		if (!hToTerm.contains(*this)) {
			hToTerm.set(*this) = (('A' <= s[0] && s[0] <= 'Z') || s.find('_')
					!= string::npos) ? B_0 : B_1;
		}
	}
public:
	G() :
		DiscreteDomainRV<int, domG> () {
	}
	G(const DiscreteDomainRV<int, domG>& rv) :
		DiscreteDomainRV<int, domG> (rv) {
	}
	G(const char* ps) :
		DiscreteDomainRV<int, domG> (ps) {
		calcDetModels(ps);
	}
	//G ( string s ) : DiscreteDomainRV<int,domG> ( s )  { calcDetModels(s); }
	B getTerm() const {
		return hToTerm.get(*this);
	}
	friend pair<StringInput, G*> operator>>(StringInput si, G& m) {
		return pair<StringInput, G*> (si, &m);
	}
	friend StringInput operator>>(pair<StringInput, G*> si_m, const char* psD) {
		if (si_m.first == NULL)
			return NULL;
		StringInput si = si_m.first
				>> (DiscreteDomainRV<int, domG>&) *si_m.second >> psD;
		si_m.second->calcDetModels(si_m.second->getString());
		return si;
	}
};
SimpleHash<G, B> G::hToTerm;
const G G_BOT("-");
const G G_TOP("ROOT");
const G G_RST("REST");

//// F: final-state...
DiscreteDomain<int> domF;
//typedef DiscreteDomainRV<char,domF> F;
class F: public DiscreteDomainRV<int, domF> {
private:
	static SimpleHash<F, G> hToG;
	static SimpleHash<G, F> hFromG;
	void calcDetModels(string s) {
		if (!hToG.contains(*this)) {
			hToG.set(*this)
					= (this->toInt() > 1) ? G(this->getString().c_str())
							: G_BOT;
			hFromG.set(G(this->getString().c_str())) = *this;
		}
	}
public:
	F() :
		DiscreteDomainRV<int, domF> () {
	}
	F(const DiscreteDomainRV<int, domF>& rv) :
		DiscreteDomainRV<int, domF> (rv) {
	}
	F(const char* ps) :
		DiscreteDomainRV<int, domF> (ps) {
		calcDetModels(ps);
	}
	F(const G& g) {
		*this = hFromG.get(g);
	}
	G getG() const {
		return hToG.get(*this);
	}
	static F getF(G g) {
		return hFromG.get(g);
	}
	friend pair<StringInput, F*> operator>>(StringInput si, F& m) {
		return pair<StringInput, F*> (si, &m);
	}
	friend StringInput operator>>(pair<StringInput, F*> si_m, const char* psD) {
		if (si_m.first == NULL)
			return NULL;
		StringInput si = si_m.first
				>> (DiscreteDomainRV<int, domF>&) *si_m.second >> psD;
		si_m.second->calcDetModels(si_m.second->getString());
		return si;
	}
};
SimpleHash<F, G> F::hToG;
SimpleHash<G, F> F::hFromG;
const F F_0("0");
const F F_1("1");
const F F_BOT("-");

//// Q: syntactic state...
typedef DelimitedJoint2DRV<psX, G, psSlash, G, psX> Q;
//class Q : public DelimitedJoint2DRV<psX,G,psSlash,G,psX> {
// public:
//  Q ( )                          : DelimitedJoint2DRV<psX,G,psSlash,G,psX> ( )        { }
//  Q ( char* ps )                 : DelimitedJoint2DRV<psX,G,psSlash,G,psX> ( ps )     { }
//  Q ( const G& g1, const G& g2 ) : DelimitedJoint2DRV<psX,G,psSlash,G,psX> ( g1, g2 ) { }
//};
#define Q_BOT Q(G_BOT,G_BOT)
#define Q_TOP Q(G_TOP,G_RST)

/* //// Q: syntactic state... */
/* DiscreteDomain<int> domQ; */
/* class Q : public DiscreteDomainRV<int,domQ> { */
/*  private: */
/*   static SimpleHash<Q,G> hToAct; */
/*   static SimpleHash<Q,G> hToAwa; */
/*   void calcDetModels ( string s ) { */
/*     if (!hToAct.contains(*this)) { */
/*       size_t i=s.find('='); i=(string::npos==i)?0:i+1; */
/*       size_t j=s.find('/'); j=(string::npos==i)?0:j; */
/*       hToAct.set(*this) = G(s.substr(i,j-i).c_str()); */
/*     } */
/*     if (!hToAwa.contains(*this)) { */
/*       size_t i=s.find('/'); */
/*       size_t j=s.find('|'); */
/*       assert(i!=string::npos && j!=string::npos);  */
/*       hToAwa.set(*this) = G(s.substr(i+1,j-1-i).c_str()); */
/*     } */
/*   } */
/*  public: */
/*   Q ( )                : DiscreteDomainRV<int,domQ> ( )    { } */
/*   Q ( const char* ps ) : DiscreteDomainRV<int,domQ> ( ps ) { calcDetModels(ps); } */
/*   G getAct ( ) const { return hToAct.get(*this); } */
/*   G getAwa ( ) const { return hToAwa.get(*this); } */
/*   friend pair<StringInput,Q*> operator>> ( StringInput si, Q& m ) { return pair<StringInput,Q*>(si,&m); } */
/*   friend StringInput operator>> ( pair<StringInput,Q*> si_m, const char* psD ) { */
/*     if ( si_m.first == NULL ) return NULL; */
/*     StringInput si=si_m.first>>(DiscreteDomainRV<int,domQ>&)*si_m.second>>psD; */
/*     si_m.second->calcDetModels(si_m.second->getString()); return si; } */
/* }; */
/* SimpleHash<Q,G> Q::hToAct; */
/* SimpleHash<Q,G> Q::hToAwa; */
/* #define Q_BOT Q("-/-") */
/* #define Q_TOP Q("ROOT/REST") */

//////////////////////////////////////// Joint Variables

//// R: collection of syntactic variables at all depths in each `reduce' phase...
typedef DelimitedJointArrayRV<4, psSemi, F> R;

//// S: collection of syntactic variables at all depths in each `shift' phase...
class S: public DelimitedJoint2DRV<psX, DelimitedJointArrayRV<4, psSemi, Q> ,
		psSemi, G, psX> {
public:
	operator G() const {
		return (((second != G_BOT) ? second
				: (first.get(3) != Q_BOT) ? first.get(3).second : (first.get(2)
						!= Q_BOT) ? first.get(2).second : (first.get(1)
						!=Q_BOT) ? first.get(1).second : first.get(0).second));
	}
	bool compareFinal(const S& s) const {
		return (*this == s);
	}
};

//// SCAR: collection of syntactic variables at all depths in each `shift' phase...
class SCRA: public DelimitedJoint4DRV<psX, S, psSemi, Cluster, psSemi, Rel, psSemi, Arg, psX> {
public:
	operator S() const {
		return first;
	}
	operator Cluster() const {
		return second;
	}
	operator Rel() const {
		return third;
	}
	operator Arg() const {
		return fourth;
	}
	bool compareFinal(const SCRA& scra) const {
		return (*this == scra);
	}
};

//// H: the set of all (marginalized) reduce and (modeled) shift variables in the HHMM...
class Y: public DelimitedJoint2DRV<psX, R, psDashDiamondDash, SCRA, psX> {
public:
	operator R() const {
		return first;
	}
	operator SCRA() const {
		return second;
	}
};

////////////////////////////////////////////////////////////////////////////////
//
//  Models
//
////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////// "Wrapper" models for individual RVs...

//// Model of F given D and F and Q (from above) and Q (from previous)
class FModel {
private:
//	HidVarCPT4DModel<F, D, G, G, LogProb> mFr; // Reduction model: F giv D, G (active cat from prev), G (awaited cat from above) (assume prev awa = reduc)
	HidVarCPT5DModel<F, D, G, G, Arg, LogProb> mFr; // Reduction model: F giv D, G (active cat from prev), G (awaited cat from above) (assume prev awa = reduc)
	static const HidVarCPT1DModel<F, LogProb> mF_0; // Fixed F_ZERO model.
	static const HidVarCPT1DModel<F, LogProb> mF_BOT; // Fixed F_BOT model.
public:
	//static bool F_ROOT_OBS;
	LogProb setIterProb(F::ArrayIterator<LogProb>& f, const D& d, const F& fD,
			const Q& qP, const Q& qU, const Arg& arg, bool b1, int& a) const {
		LogProb pr;
//		cerr << "FModel: d="<<d<<",fD="<<fD<<",qP="<<qP<<",qU="<<qU<<",a="<<a<<endl;
		if (fD == F_BOT && (qP.second == G_BOT)) {
			// >1 (bottom) case...
			pr = mF_BOT.setIterProb(f, a);
		}
		//else if ( fD>F_1 && (qP.second==F(fD).getG() || (qP.second.getTerm()==B_1 && fD==F_BOT)) ) {
		else if (fD == F_BOT && qP.second.getTerm() == B_1) {
			// >1 (middle) case...
			pr = mFr.setIterProb(f, d, qP.first, qU.second, arg, a);
			if (a < -1 && pr == LogProb())
				cerr << "\nERROR: no condition Fr " << d << " " << qP.first
						<< " " << qU.second << "\n\n";
		}
		//if ( fD==F_0 || (qP.second!=F(fD).getG() && !(qP.second.getTerm()==B_1 && F(fD).getG()==G_NONE)) ) ) {
		else {
			// 0 (top) case...
			pr = mF_0.setIterProb(f, a);
		}

		//cerr << "Prob before weird condition: " << pr.toProb() << endl;
		// Iterate again if result doesn't match root observation...
		if (a >= -1 && d == D_1 && b1 != (F(f) > F_1)){
		    //cerr << "                  Weird condition triggered ******" << endl;
		    //if(F_ROOT_OBS){
//               cerr << "For some reason F_ROOT_OBS is triggered?" << endl;
//            }
			pr = LogProb();
		}
		//cerr<<"    F "<<d<<" "<<fD<<" "<<qP<<" "<<qU<<" : "<<f<<" = "<<pr<<" ("<<a<<")\n";
		return pr;
	}
	friend pair<StringInput, FModel*> operator>>(StringInput si, FModel& m) {
		return pair<StringInput, FModel*> (si, &m);
	}
	friend StringInput operator>>(pair<StringInput, FModel*> si_m,
			const char* psD) {
		StringInput si;
		return ((si = si_m.first >> "Fr " >> si_m.second->mFr >> psD) != NULL) ? si
				: StringInput(NULL);
	}
};
const HidVarCPT1DModel<F, LogProb> FModel::mF_0(F_0);
const HidVarCPT1DModel<F, LogProb> FModel::mF_BOT(F_BOT);
//bool FModel::F_ROOT_OBS = false;


class ClusterModel {
private:
	HidVarCPT1DModel<Cluster, LogProb> mClusterPrior;
	HidVarCPT2DModel<Cluster, Rel, LogProb> mCluster;
	static HidVarCPT2DModel<Cluster, Cluster, LogProb> mClusterCopy;
public:
  LogProb setIterProb(Cluster::ArrayIterator<LogProb>& cluster, const Cluster& cP, const Rel::ArrayIterator<LogProb>& rC, int& a) const {
    LogProb pr;
    //cerr << "enter cluster setIterProb: cP=" << cP << endl << " cluster=" << cluster << " rel=" << rC << endl;
    if(Cluster(cluster) == CLUSTER_START){
			pr = mClusterPrior.setIterProb(cluster, a);
			pr *= mCluster.setIterProb(cluster, Rel(rC), a);
      //pr = mCluster.setIterProb(cluster, Rel(rC), a);
      //cerr << "cluster start" << endl;
    } else {
      if(!mClusterCopy.contains(cP)) mClusterCopy.setProb(cP,cP) = 1.0;
      pr = mClusterCopy.setIterProb(cluster,cP,a);
      //cerr << "cluster copied" << endl;
    }
    //cerr << "cluster:" << cluster << endl;
    return pr;

	}

	friend pair<StringInput, ClusterModel*> operator>>(StringInput si, ClusterModel& m) {
		return pair<StringInput, ClusterModel*> (si, &m);
	}
	friend StringInput operator>>(pair<StringInput, ClusterModel*> si_m,
																const char* psD) {
		StringInput si;
		return ((si = si_m.first >> "Clp " >> si_m.second->mClusterPrior >> psD) != NULL
						|| (si = si_m.first >> "Cl " >> si_m.second->mCluster >> psD) != NULL ) ? si : StringInput(NULL);
	}
};
HidVarCPT2DModel<Cluster, Cluster, LogProb> ClusterModel::mClusterCopy;

//// Model of semantic relation for predicate REL
class RelModel {
private:
	//HidVarCPT2DModel<Rel, Rel, LogProb> mRel;
	static HidVarCPT2DModel<Rel, Rel, LogProb> mRelCopy;

public:
	LogProb setIterProb(Rel::ArrayIterator<LogProb>& rel, const Rel& rP, int& a) const {
		LogProb pr;
    //cerr << "enter cluster setIterProb: cP=" << cP << endl; //<< " cluster=" << cluster << endl;
//    if ( rP.getString().find(".") == string::npos) {
//      pr = mRel.setIterProb(rel, rP, a);
//    }else{
//      if(!mRelCopy.contains(rP)) mRelCopy.setProb(rP,rP) = 1.0;
//      pr = mRelCopy.setIterProb(rel, rP, a);
//    }
		if(!mRelCopy.contains(rP))
			mRelCopy.setProb(rP,rP) = 1.0;
		pr = mRelCopy.setIterProb(rel, rP, a);
    return pr;
	}

	friend pair<StringInput, RelModel*> operator>>(StringInput si, RelModel& m) {
		return pair<StringInput, RelModel*> (si, &m);
	}
	friend StringInput operator>>(pair<StringInput, RelModel*> si_m,
			const char* psD) {
		StringInput si;
//		return ((si = si_m.first >> "Rel " >> si_m.second->mRel >> psD) != NULL) ? si : StringInput(NULL);
//		return ((si = si_m.first >> "Vs " >> si_m.second->mRel >> psD) != NULL) ? si : StringInput(NULL);
		return StringInput(NULL);
	}
};
HidVarCPT2DModel<Rel, Rel, LogProb> RelModel::mRelCopy;

//// Model of sematic argument for predicate
class ArgModel {
private:
	//HidVarCPT2DModel<Arg, Rel, LogProb> mAi;
//	HidVarCPT4DModel<Arg, D, Arg, F, LogProb> mA; //mAt;
//	HidVarCPT6DModel<Arg, D, Arg, G, F, B, LogProb> mA; //mAt;
	HidVarCPT7DModel<Arg, D, Arg, Cluster, G, F, B, LogProb> mA; //mAt;
	//	HidVarCPT5DModel<Arg, D, Cluster, Arg, F, LogProb> mA;
public:
	LogProb setIterProb(Arg::ArrayIterator<LogProb>& arg, const D& d, const Arg& aP,
			const Cluster::ArrayIterator<LogProb>& rC, const G& g, const F& f, const B& b, int& a) const {
//		LogProb pr = mAi.setIterProb(arg, Rel(rC), a);
//		pr *= mAt.setIterProb(arg, Rel(rC), aP, a);
//		LogProb pr = mA.setIterProb(arg, d, aP, Cluster(rC), f, a);
			//LogProb pr = mA.setIterProb(arg, d, aP, g, f, b, a);
			LogProb pr = mA.setIterProb(arg, d, aP, Cluster(rC), g, f, b, a);
		//cerr << "arg: " << arg << ", d=" << d << ", rC=" << rC << "aP=" << aP << "aF=" << f << ",pr = " << pr << endl;
		return pr;
	}

	friend pair<StringInput, ArgModel*> operator>>(StringInput si, ArgModel& m) {
		return pair<StringInput, ArgModel*> (si, &m);
	}
	friend StringInput operator>>(pair<StringInput, ArgModel*> si_m,
			const char* psD) {
		StringInput si;
//		return ((si = si_m.first >> "Ai " >> si_m.second->mAi >> psD) != NULL
//				|| (si = si_m.first >> "At " >> si_m.second->mAt >> psD)
//						!= NULL) ? si : StringInput(NULL);
		return ((si = si_m.first >> "A " >> si_m.second->mA >> psD) != NULL) ? si : StringInput(NULL);
	}
};

//// Model of Q given D and F and F and Q(from prev) and Q(from above)
class QModel {
public:
	HidVarCPT4DModel<G, D, G, Arg, LogProb> mGe; // Expansion model of G given D, G (from above), and A (semantic argument)
//	HidVarCPT3DModel<G, D, G, LogProb> mGegf; // fallback model for mGe

private:
	HidVarCPT5DModel<G, D, G, G, Arg, LogProb> mGtm; // Awaited transition model of G (active) given D, G (awaited cat from prev), G (from reduction)
//	HidVarCPT4DModel<G, D, G, G, LogProb> mGtmo; // Awaited transition model of G (active) given D, G (awaited cat from prev), G (from reduction)
	HidVarCPT5DModel<G, D, G, G, Arg, LogProb> mGtp; // Active Transition model of G (active) given D, G (active cat from prev), G (awaited cat from above)
	HidVarCPT5DModel<G, D, G, G, Arg, LogProb> mGtq; // Active Transition completion of G (awaited) given D, G (active cat from curr), G (active cat from prev)
	static const HidVarCPT1DModel<G, LogProb> mG_BOT; // Fixed G_BOT model.
	static HidVarCPT2DModel<G, G, LogProb> mG_COPY; // Cached F_COPY model  --  WARNING: STATIC NON-CONST is not thread safe!

//	HidVarCPT4DModel<G, D, G, G, LogProb> mGtmgf; // fallback model for mGtm
//	HidVarCPT4DModel<G, D, G, G, LogProb> mGtpgf; // fallback model for mGtp
//	HidVarCPT4DModel<G, D, G, G, LogProb> mGtqgf; // fallback model for mGtq

public:
	LogProb setIterProb(Q::ArrayIterator<LogProb>& q, const D& d, const F& fD,
			const F& f, const Q& qP, const Q& qU, const Arg::ArrayIterator<LogProb>& argC, int& a) const {
		//cerr << "luan" << q << " : " << d << " : " << fD << " : " << f << " : " << qP << " : " << qU << " : " << argC << " : " << a << "naul\n";
		LogProb pr, p;
		Arg arg = Arg(argC);
		if (fD > F_1) {
			if (f >= F_1) {
				if (f > F_1) {
					if (qU.second.getTerm() == B_1 || qU == Q_BOT) {
						////cerr<<"a\n";
						// >1 >1 (expansion to null) case:
						pr = mG_BOT.setIterProb(q.first, a);
						pr *= mG_BOT.setIterProb(q.second, a);
					} else {
						////cerr<<"b\n";
						// >1 >1 (expansion) case:
						pr = p = mGe.setIterProb(q.first, d, qU.second, arg, a);
						if (a < -1 && p == LogProb()) {
							cerr << "\nERROR: no condition Ge " << d << " "
							<< qU.second << " " << arg << " " << "\n\n";
							//try the fallback model
//							a++;
//							pr = p = mGegf.setIterProb(q.first, d, qU.second, a);
//							if (a < -1 && p == LogProb())
//							  cerr << "\nERROR: no condition Gegf " << d << " "
//									<< qU.second << " " << "\n\n";
						}
						if (!mG_COPY.contains(G(q.first)))
							mG_COPY.setProb(G(q.first), G(q.first)) = 1.0;
						pr *= p = mG_COPY.setIterProb(q.second, G(q.first), a);
					}
				} else {
					////cerr<<"c\n";
					// >1 1 ('plus' transition following reduction) case:
					pr = p = mGtp.setIterProb(q.first, d, qP.first, qU.second,
							 arg, a);
					if (a < -1 && p == LogProb()) {
						cerr << "\nERROR: no condition Gtp " << d << " "
						<< qP.first << " " << qU.second << " " << arg << " " << "\n\n";
						//try the fallback model
//						a++;
//						pr = p = mGtpgf.setIterProb(q.first, d, qP.first, qU.second, a);
//						if (a < -1 && p == LogProb())
//						  cerr << "\nERROR: no condition Gtpgf " << d << " "
//								<< qP.first << " " << qU.second << " "  << "\n\n";
					}
					p = mGtq.setIterProb(q.second, d, G(q.first),
							qP.first, arg, a);
					if (a < -1 && p == LogProb()) {
						cerr << "\nERROR: no condition Gtq " << d << " " << G(q.first) << " " << qP.first << " " << arg << " " << "\n\n";
						//try the fallback model
//						a++;
//						p = mGtqgf.setIterProb(q.second, d, G(q.first),
//																 qP.first, a);
//						if (a < -1 && p == LogProb())
//							cerr << "\nERROR: no condition Gtqgf " << d << " " << G(
//								q.first) << " " << qP.first << " " << "\n\n";
					}
					pr *= p;
				}
			} else {
				////cerr<<"d\n";
				// >1 0 ('minus' transition without reduction) case:
				if (!mG_COPY.contains(qP.first))
					mG_COPY.setProb(qP.first, qP.first) = 1.0;
				pr = p = mG_COPY.setIterProb(q.first, qP.first, a);

//				if (fD.getG().getString() == "fake") {
//					pr *= p = mGtmo.setIterProb(q.second, d, fD.getG(),
//								qP.second, a);
//				} else {
				p = mGtm.setIterProb(q.second, d, fD.getG(),
												qP.second, arg, a);
//				}
				if (a < -1 && p == LogProb()) {
					cerr << "\nERROR: no condition Gtm " << d << " "
					<< fD.getG() << " " << qP.second << " " << arg << " " << "\n\n";
					//try the fallback model
//					a++;
//					p = mGtmgf.setIterProb(q.second, d, fD.getG(),
//															 qP.second, a);
//					if (a < -1 && p == LogProb())
//						cerr << "\nERROR: no condition Gtmgf " << d << " "
//							<< fD.getG() << " " << qP.second << " " << "\n\n";
				}
				pr *= p;
			}
		} else {
			////cerr<<"e\n";
			// <=1 0 (copy) case:
			if (!mG_COPY.contains(qP.first))
				mG_COPY.setProb(qP.first, qP.first) = 1.0;
			pr = p = mG_COPY.setIterProb(q.first, qP.first, a);
			if (!mG_COPY.contains(qP.second))
				mG_COPY.setProb(qP.second, qP.second) = 1.0;
			pr *= p = mG_COPY.setIterProb(q.second, qP.second, a);
		}
		//cerr<<"    Q "<<d<<" "<<fD<<" "<<f<<" "<<qP<<" "<<qU<< " "<<argC <<" : "<<q<<" = "<<pr<<" ("<<a<<")\n";
		return pr;
	}
	friend pair<StringInput, QModel*> operator>>(StringInput si, QModel& m) {
		return pair<StringInput, QModel*> (si, &m);
	}
	friend StringInput operator>>(pair<StringInput, QModel*> si_m,
			const char* psD) {
		StringInput si;
		return ((si = si_m.first >> "Gtm " >> si_m.second->mGtm >> psD) != NULL
//				|| (si = si_m.first >> "Gtmo " >> si_m.second->mGtmo >> psD) != NULL
				|| (si = si_m.first >> "Gtp " >> si_m.second->mGtp >> psD) != NULL
				|| (si = si_m.first >> "Gtq " >> si_m.second->mGtq >> psD) != NULL
				|| (si = si_m.first >> "Ge " >> si_m.second->mGe >> psD) != NULL
/*				|| (si = si_m.first >> "Gtmgf " >> si_m.second->mGtmgf >> psD) != NULL
				|| (si = si_m.first >> "Gtpgf " >> si_m.second->mGtpgf >> psD) != NULL
				|| (si = si_m.first >> "Gtqgf " >> si_m.second->mGtqgf >> psD) != NULL
				|| (si = si_m.first >> "Gegf " >> si_m.second->mGegf >> psD) != NULL */) ? si : StringInput(NULL);
	}
};
const HidVarCPT1DModel<G, LogProb> QModel::mG_BOT(G_BOT);
HidVarCPT2DModel<G, G, LogProb> QModel::mG_COPY;

//////////////////////////////////////// Joint models...

//////////////////// Reduce phase...

//// Model of R given S
class RModel: public SingleFactoredModel<FModel> {
public:
	LogProb setIterProb(R::ArrayIterator<LogProb>& r, const S& sP, const Arg& arg, bool b1, int& a) const {
		const FModel& mF = getM1();
		LogProb pr;
		//cerr << "sP = " << sP << ", arg = " << arg << ", a = " << a << endl;
		pr = mF.setIterProb(r.set(4 - 1), 4, F(sP.second), sP.first.get(4 - 1),
				sP.first.get(3 - 1), arg, b1, a);
		pr *= mF.setIterProb(r.set(3 - 1), 3, F(r.get(4 - 1)), sP.first.get(3
				- 1), sP.first.get(2 - 1), arg, b1, a);
		pr *= mF.setIterProb(r.set(2 - 1), 2, F(r.get(3 - 1)), sP.first.get(2
				- 1), sP.first.get(1 - 1), arg, b1, a);
		pr *= mF.setIterProb(r.set(1 - 1), 1, F(r.get(2 - 1)), sP.first.get(1
				- 1), Q_TOP, arg, b1, a);
		return pr;
	}
};

//////////////////// Shift phase...
class SModel : public SingleFactoredModel<QModel> {
private:
	static const HidVarCPT1DModel<G, LogProb> mG_BOT;
public:
    LogProb setIterProb ( S::ArrayIterator<LogProb>& s, const R::ArrayIterator<LogProb>& r, const S& sP, const Arg::ArrayIterator<LogProb>& arg, int& a ) const {
        const QModel& mQ = getM1();
        LogProb pr;

 		pr = mQ.setIterProb(s.first.set(1 - 1), 1, F(r.get(2 - 1)), F(
				r.get(1 - 1)), sP.first.get(1 - 1), Q_TOP, arg, a);
		pr *= mQ.setIterProb(s.first.set(2 - 1), 2, F(r.get(3 - 1)), F(
				r.get(2 - 1)), sP.first.get(2 - 1), Q().setVal(
				s.first.set(1 - 1)), arg, a);
		pr *= mQ.setIterProb(s.first.set(3 - 1), 3, F(r.get(4 - 1)), F(
				r.get(3 - 1)), sP.first.get(3 - 1), Q().setVal(
				s.first.set(2 - 1)), arg, a);
		pr *= mQ.setIterProb(s.first.set(4 - 1), 4, sP.second, F(
				r.get(4 - 1)), sP.first.get(4 - 1), Q().setVal(
				s.first.set(3 - 1)), arg, a);
		pr
				*= (G(s.first.set(4 - 1).second) != G_BOT && G(
						s.first.set(4 - 1).second).getTerm() != B_1) ? mQ.mGe.setIterProb(
						s.second, 5, G(s.first.set(4 - 1).second),
						Arg(arg), a)
						: mG_BOT.setIterProb(s.second, a);
		return pr;
    }
};

//class RCModel: public DoubleFactoredModel<RelModel, ClusterModel>{
//
//};
//class RCAModel: public DoubleFactoredModel<RCModel, ArgModel>{
//};


//// Model of S given R and S
class SCRAModel: public QuadrupleFactoredModel<SModel, ClusterModel, RelModel, ArgModel> {
//class SCRAModel: public DoubleFactoredModel<SModel, RCAModel> {
public:
	LogProb setIterProb(SCRA::ArrayIterator<LogProb>& s, const R::ArrayIterator<LogProb>& r, const SCRA& sP, int& a) const {
		const SModel& mS = getM1();
		const ClusterModel& mCluster = getM2();
		const RelModel& mRel = getM3();
		const ArgModel& mArg = getM4();
		LogProb pr;
		//cerr << "Scra::setIterProb(): sP = " << sP << ", a = " << a << endl;
		pr = mRel.setIterProb(s.third, sP.third, a);
		if(pr == LogProb())  return pr;
		//cerr << "s.third = " << s.third << endl;

		pr *= mCluster.setIterProb(s.second, sP.second, s.third, a);
		if(pr == LogProb())  return pr;

		//cerr << "s.second = " << s.second << endl;
		R activeR; activeR.setVal(r);
//		R activeR = R(r);
		G awaitedG;
		B inLevel;
		F activeF;
		D d;
		if (activeR.get(3) == F_0) {
			activeF = sP.first.second;
			awaitedG = sP.first.first.get(3).second;
			d=D_5;
			inLevel = B_0;
		}
		else if (activeR.get(2) == F_0) {
			if (activeR.get(3) == F_1) {
				activeF = sP.first.first.get(3).first;
				inLevel = B_1;
			} else {
				activeF = activeR.get(3);
				inLevel = B_0;
			}
			awaitedG = sP.first.first.get(2).second;
			d=D_4;
		}
		else if (activeR.get(1) == F_0) {
			if (activeR.get(2) == F_1) {
				activeF = sP.first.first.get(2).first;
				inLevel = B_1;
			} else {
				activeF = activeR.get(2);
				inLevel = B_0;
			}
			awaitedG = sP.first.first.get(1).second;
			d=D_3;
		}
		else if (activeR.get(0) == F_0) {
			if (activeR.get(1) == F_1) {
				activeF = sP.first.first.get(1).first;
				inLevel = B_1;
			} else {
				activeF = activeR.get(1);
				inLevel = B_0;
			}
			awaitedG = sP.first.first.get(0).second;
			d=D_2;
		}
		else {
			if (activeR.get(0) == F_1) {
				activeF = sP.first.first.get(0).first;
				inLevel = B_1;
			} else {
				activeF = activeR.get(0);
				inLevel = B_0;
			}
			awaitedG = G_RST;
			d=D_1;
		}
		//cerr << "activeF=" << activeF << endl;

//		F activeF = activeR.get(3) == F_0 ? sP.first.second :
//		activeR.get(2) == F_0 ? (activeR.get(3) == F_1 ? sP.first.first.get(3).second : activeR.get(3)) :
//		activeR.get(1) == F_0 ? (activeR.get(2) == F_1 ? sP.first.first.get(2).second : activeR.get(2))  :
//		activeR.get(0) == F_0 ? (activeR.get(1) == F_1 ? sP.first.first.get(1).second : activeR.get(1)) :  (activeR.get(0) == F_1 ? sP.first.first.get(0).second : activeR.get(0))  ;

		pr *= mArg.setIterProb(s.fourth, d, sP.fourth, s.second, awaitedG, activeF, inLevel, a);
		//cerr << "Arg " << s.fourth << " " << sP.fourth << " " << s.second << ", pr=" << pr.toProb() << endl;
		pr *= mS.setIterProb(s.first, r, sP.first, s.fourth, a);


		//cerr << "SRA = " << s << ", pr = " << pr.toProb() << ", a = " << a << endl;
		//cerr<<"  G "<<5<<" "<<G(q4.second)<<" : "<<g<<" = "<<pr<<" ("<<a<<")\n";
		return pr;
	}
};
const HidVarCPT1DModel<G, LogProb> SModel::mG_BOT(G_BOT);

//////////////////// Overall...

//// Model of H=R,S given S
class YModel: public DoubleFactoredModel<RModel, SCRAModel> {
public:
	static X WORD;
//	static bool& F_ROOT_OBS;
	typedef Y::ArrayIterator<LogProb> IterVal;
	SCRA& setTrellDat(SCRA& s, const Y::ArrayIterator<LogProb>& h) const {
		s.setVal(h.second);
		return s;
	}
	R setBackDat(const Y::ArrayIterator<LogProb>& h) const {
		R r;
		for (int i = 0; i < 4; i++)
			r.set(i) = F(h.first.get(i));
		return r;
	}
	LogProb setIterProb(Y::ArrayIterator<LogProb>& h, const SCRA& sP, const X& x, bool b1, int& a) const {
		const RModel& mR = getM1();
		const SCRAModel& mS = getM2();
		LogProb pr;
		//cerr << "Before R::setIterProb(), sP = " << sP << "< r=" << h.first << ", pr=" << pr.toProb() << endl;
		pr = mR.setIterProb(h.first, sP.first, sP.fourth, b1, a);
		//cerr << "After R::setIterProb(), sP = " << sP << "< r=" << h.first << ", pr=" << pr.toProb() << " (a=" << a << ")" << endl;
		if (LogProb() == pr)
			return pr;
		pr *= mS.setIterProb(h.second, h.first, sP, a);
		//cerr << "After H::setIterProb(), scra = " << h.second << ", pr=" << pr.toProb() << endl;
		return pr;
	}
	void update() const {
	}
};
X     YModel::WORD;
//bool& YModel::F_ROOT_OBS = FModel::F_ROOT_OBS;

