///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. //
//                                                                           //
//    ModelBlocks is free software: you can redistribute it and/or modify    //
//    it under the terms of the GNU General Public License as published by   //
//    the Free Software Foundation, either version 3 of the License, or      //
//    (at your option) any later version.                                    //
//                                                                           //
//    ModelBlocks is distributed in the hope that it will be useful,         //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          //
//    GNU General Public License for more details.                           //
//                                                                           //
//    You should have received a copy of the GNU General Public License      //
//    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include "nl-cpt.h"
#include "TextObsVars.h"

char psX[]="";
char psSlash[]="/";
char psComma[]=",";
char psSemi[]=";";
char psSemiSemi[]=";;";
char psDashDiamondDash[]="-<>-";
char psTilde[]="~";
//char psBar[]="|";
char psLBrace[]="{";
char psRBrace[]="}";
char psLangle[]="<";
char psRangle[]=">";
char psLbrack[]="[";
char psRbrack[]="]";

const char* BEG_STATE = "-:-{-}/-:-{-};-:-{-}/-:-{-};-:-{-}/-:-{-};-:-{-}/-:-{-};-:-{-}";
const char* END_STATE = "meos:eos{e0}/meos:eos{e0};-:-{-}/-:-{-};-:-{-}/-:-{-};-:-{-}/-:-{-};-:-{-}";


////////////////////////////////////////////////////////////////////////////////
//
//  Random Variables
//
////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////// Simple Variables

//// B: boolean
DiscreteDomain<char> domB;
//typedef DiscreteDomainRV<char,domB> B;
class B : public DiscreteDomainRV<char,domB> {
 public:
  B ( )                : DiscreteDomainRV<char,domB> ( )    { }
  B ( const char* ps ) : DiscreteDomainRV<char,domB> ( ps ) { }
};
const B B_0 ("0");
const B B_1 ("1");


//// D: depth (input only, to HHMM models)...
DiscreteDomain<char> domD;
//typedef DiscreteDomainRV<char,domD> D;
class D : public DiscreteDomainRV<char,domD> {
 public:
  D ( )                : DiscreteDomainRV<char,domD> ( )    { }
  D ( int i )          : DiscreteDomainRV<char,domD> ( i )  { }
  D ( const char* ps ) : DiscreteDomainRV<char,domD> ( ps ) { }
};
const D D_0("0");
const D D_1("1");
const D D_2("2");
const D D_3("3");
const D D_4("4");
const D D_5("5");


//// L: relation label
DiscreteDomain<int> domL;
//typedef DiscreteDomainRV<int,domL> L;
class L : public DiscreteDomainRV<int,domL> {
 public:
  L ( )                : DiscreteDomainRV<int,domL> ( )    { }
  L ( const char* ps ) : DiscreteDomainRV<int,domL> ( ps ) { }
};
const L L_NIL("-");


//// C: constituent category
DiscreteDomain<int> domC;
//typedef DiscreteDomainRV<int,domC> C;
class C : public DiscreteDomainRV<int,domC> {
 public:
  C ( )                : DiscreteDomainRV<int,domC> ( )    { }
  C ( const char* ps ) : DiscreteDomainRV<int,domC> ( ps ) { }
};
const C C_NIL("-");


//// I: concept index
DiscreteDomain<int> domI;
//typedef DiscreteDomainRV<int,domI> I;
class I : public DiscreteDomainRV<int,domI> {
 public:
  I ( )                                      : DiscreteDomainRV<int,domI> ( )    { }
  I ( const DiscreteDomainRV<int,domI>& rv ) : DiscreteDomainRV<int,domI> ( rv ) { }
  I ( const char* ps )                       : DiscreteDomainRV<int,domI> ( ps ) { }
};
const I I_NIL("-");


//////////////////////////////////////// Formally Joint Variables Implemented as Simple Variables

//// G: constituent category (=LC)...
DiscreteDomain<int> domG;
//typedef DiscreteDomainRV<int,domG> G;
class G : public DiscreteDomainRV<int,domG> {
 private:
  static SimpleHash<G,L> hToL;
  static SimpleHash<G,C> hToC;
  static SimpleHash<G,B> hToTerm;
  void calcDetModels ( string s ) {
    if (!hToL.contains(*this)) {
      size_t i=s.find(':');
      assert(i!=string::npos);
      hToL.set(*this) = L(s.substr(0,i).c_str());
    }
    if (!hToC.contains(*this)) {
      size_t i=s.find(':');
      assert(i!=string::npos); 
      hToC.set(*this) = C(s.substr(i+1).c_str());
      hToTerm.set(*this) = (('A'<=s.substr(i+1).c_str()[0] && s.substr(i+1).c_str()[0]<='Z') || s.find('_')!=string::npos) ? B_0 : B_1;
    }
  }
 public:
  G ( )                : DiscreteDomainRV<int,domG> ( )    { }
  G ( const DiscreteDomainRV<int,domG>& rv ) : DiscreteDomainRV<int,domG>(rv) { }
  G ( const char* ps ) : DiscreteDomainRV<int,domG> ( ps ) { calcDetModels(ps); }
  //G ( string s ) : DiscreteDomainRV<int,domG> ( s )  { calcDetModels(s); }
  L getL    ( )     const { return hToL.get(*this); }
  C getC    ( )     const { return hToC.get(*this); }
  B getTerm ( ) const { return hToTerm.get(*this); }
  friend pair<StringInput,G*> operator>> ( StringInput si, G& m ) { return pair<StringInput,G*>(si,&m); }
  friend StringInput operator>> ( pair<StringInput,G*> si_m, const char* psD ) {
    if ( si_m.first == NULL ) return NULL;
    StringInput si=si_m.first>>(DiscreteDomainRV<int,domG>&)*si_m.second>>psD;
    si_m.second->calcDetModels(si_m.second->getString()); return si; }
};
SimpleHash<G,L> G::hToL;
SimpleHash<G,C> G::hToC;
SimpleHash<G,B> G::hToTerm;
const G G_LEX("-:-");
const G G_TOP("h:DISC");
const G G_RST("h:REST");


//// F: final-state (=BG)...
DiscreteDomain<int> domF;
//typedef DiscreteDomainRV<char,domF> F;
class F : public DiscreteDomainRV<int,domF> {
 private:
  static SimpleHash<F,B> hToB;
  static SimpleHash<F,G> hToG;
  static SimpleHash<G,F> hFromG;
  void calcDetModels ( string s ) {
    if (!hToB.contains(*this)) {
      size_t i=s.find(',');
      assert(i!=string::npos);
      hToB.set(*this) = B(s.substr(0,i).c_str());
    }
    if (!hToG.contains(*this)) {
      size_t i=s.find(',');
      assert(i!=string::npos); 
      hToG.set(*this) = G(s.substr(i+1).c_str());
      if ( '1'==s[0] )
        hFromG.set(G(s.substr(i+1).c_str())) = *this;
    }
/*     if (!hToG.contains(*this)) { */
/*       hToG.set(*this) = G(this->toInt()>1) ? G(this->getString().c_str()) : G_BOT; */
/*       hFromG.set(G(this->getString().c_str())) = *this; */
/*     } */
  }
 public:
  F ( )                                      : DiscreteDomainRV<int,domF> ( )    { }
  F ( const DiscreteDomainRV<int,domF>& rv ) : DiscreteDomainRV<int,domF>(rv)    { }
  F ( const char* ps )                       : DiscreteDomainRV<int,domF> ( ps ) { calcDetModels(ps); }
  F ( const G& g )                                                               { *this = hFromG.get(g); }
  B        getB ( )     const { return hToB.get(*this); }
  G        getG ( )     const { return hToG.get(*this); }
  static F getF ( G g )       { return hFromG.get(g); }
  friend pair<StringInput,F*> operator>> ( StringInput si, F& m ) { return pair<StringInput,F*>(si,&m); }
  friend StringInput operator>> ( pair<StringInput,F*> si_m, const char* psD ) {
    if ( si_m.first == NULL ) return NULL;
    StringInput si=si_m.first>>(DiscreteDomainRV<int,domF>&)*si_m.second>>psD;
    si_m.second->calcDetModels(si_m.second->getString()); return si; }
};
SimpleHash<F,B> F::hToB;
SimpleHash<F,G> F::hToG;
SimpleHash<G,F> F::hFromG;
const F F_NOC("0,-:-"); // BOT
const F F_LEX("1,-:-"); // TOP


//////////////////////////////////////// Formally and Implementationally Joint Variables

//// Q: syntactic state...
//typedef DelimitedJoint2DRV<psX,G,psSlash,G,psX> Q;
//#define Q_LEX Q(G_LEX,G_LEX)
//#define Q_TOP Q(G_TOP,G_RST)


//// II: concept index relation...
//typedef DelimitedJoint2DRV<psX,I,psComma,I,psX> II;
//#define II_LEX II(I_LEX,I_LEX)
//#define II_TOP II(I_TOP,I_TOP)


//// GI: ad hoc preterminal element...
class GI : public DelimitedJoint2DRV<psX,G,psLBrace,I,psRBrace> {
  typedef DelimitedJoint2DRV<psX,G,psLBrace,I,psRBrace> Parent;
 public:
  GI ( )                                : Parent()    { }
  template<class P>
  GI ( const GI::ArrayIterator<P>& it )               { setVal(it); }
  GI ( const G& g, const I& i )         : Parent(g,i) { }
  const G& getG ( ) const { return first;  }
  const I& getI ( ) const { return second; }
  template<class P> class ArrayIterator : public Parent::ArrayIterator<P> {
   public:
    G::ArrayIterator<P>& setG ( )  { return Parent::ArrayIterator<P>::first;  }
    I::ArrayIterator<P>& setI ( )  { return Parent::ArrayIterator<P>::second; }
  };
  friend pair<StringInput,GI*> operator>> ( StringInput si, GI& gi ) { return pair<StringInput,GI*>(si,&gi); }
  friend StringInput operator>> ( pair<StringInput,GI*> si_gi, const char* psD ) {
    if ( si_gi.first == NULL ) return NULL;
    StringInput si = si_gi.first>>*(Parent*)si_gi.second>>psD;
    return si;
  }
};
const GI GI_LEX(G_LEX,I_NIL);
const GI GI_TOP(G_TOP,I_NIL);
const GI GI_RST(G_RST,I_NIL);
//typedef DelimitedJoint2DRV<psX,G,psLBrace,I,psRBrace> GI;
//#define GI_LEX GI(G_LEX,I_LEX)
//#define GI_TOP GI(G_TOP,I_TOP)


//// Rd: reduce element...
class Rd : public DelimitedJoint2DRV<psX,F,psLBrace,I,psRBrace> {
  typedef DelimitedJoint2DRV<psX,F,psLBrace,I,psRBrace> Parent;
 public:
  Rd ( )                                : Parent()                    { }
  template<class P>
  Rd ( const Rd::ArrayIterator<P>& it )                               { setVal(it); }
  Rd ( const F& f, const I& i )         : Parent(f,i)                 { }
  Rd ( const GI& gi )                   : Parent(gi.getG(),gi.getI()) { }
  const F& getF ( ) const { return first;  }
  const I& getI ( ) const { return second; }
  template<class P> class ArrayIterator : public Parent::ArrayIterator<P> {
   public:
    F::ArrayIterator<P>& setF ( )  { return Parent::ArrayIterator<P>::first;  }
    I::ArrayIterator<P>& setI ( )  { return Parent::ArrayIterator<P>::second; }
  };
};
const Rd Rd_LEX(F_LEX,I_NIL);


//// Sd: store element...
class Sd : public DelimitedJoint2DRV<psX,GI,psSlash,GI,psX> {
  typedef DelimitedJoint2DRV<psX,GI,psSlash,GI,psX> Parent;
 public:
  Sd ( )                                : Parent()        { }
  template<class P>
  Sd ( const Sd::ArrayIterator<P>& it )                   { setVal(it); }
  Sd ( const GI& gia, const GI& giw )   : Parent(gia,giw) { }
  const GI& getAct ( ) const { return first;  }
  const GI& getAwa ( ) const { return second; }
  template<class P> class ArrayIterator : public Parent::ArrayIterator<P> {
   public:
    GI::ArrayIterator<P>& setAct ( )  { return Parent::ArrayIterator<P>::first;  }
    GI::ArrayIterator<P>& setAwa ( )  { return Parent::ArrayIterator<P>::second; }
  };
  friend pair<StringInput,Sd*> operator>> ( StringInput si, Sd& sd ) { return pair<StringInput,Sd*>(si,&sd); }
  friend StringInput operator>> ( pair<StringInput,Sd*> si_sd, const char* psD ) {
    if ( si_sd.first == NULL ) return NULL;
    StringInput si = si_sd.first>>*(Parent*)si_sd.second>>psD;
    return si;
  }
};
//typedef DelimitedJoint2DRV<psX,GI,psSlash,GI,psX> Sd;
const Sd Sd_TOP(GI_TOP,GI_RST);
const Sd Sd_LEX(GI_LEX,GI_LEX);
//typedef DelimitedJoint2DRV<psX,Q,psLBrace,II,psRBrace> Sd;
//#define Sd_TOP Sd(Q_TOP,II_TOP)
//#define Sd_LEX Sd(Q_LEX,II_LEX)


//// R: collection of syntactic variables at all depths in each `reduce' phase...
typedef DelimitedJointArrayRV<4,psSemi,Rd> R;

//// S: collection of syntactic variables at all depths in each `shift' phase...
class S : public DelimitedJoint2DRV<psX,DelimitedJointArrayRV<4,psSemi,Sd>,psSemi,GI,psX> {
 public:
  operator GI()  const { return ( ( (second      !=GI_LEX) ? second       :
                                    (first.get(3)!=Sd_LEX) ? first.get(3).second :
                                    (first.get(2)!=Sd_LEX) ? first.get(2).second :
                                    (first.get(1)!=Sd_LEX) ? first.get(1).second :
                                                             first.get(0).second ) ); }
  bool compareFinal ( const S& s ) const { return(*this==s); }
};

//// Y: the set of all (marginalized) reduce and (modeled) shift variables in the HHMM...
class Y : public DelimitedJoint2DRV<psX,R,psDashDiamondDash,S,psX>
{ public:
  operator R() const {return first;}
  operator S() const {return second;}
};


////////////////////////////////////////////////////////////////////////////////
//
//  Models
//
////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////// "Wrapper" models for individual RVs...

//// Model of Rd given D and Rd and Sd (from above) and Sd (from previous)
class RdModel {
 private:
  HidVarCPT4DModel<F,D,GI,GI,LogProb>        mFr;     // Reduction model: F giv D, GI (active cat from prev), GI (awaited cat from above) (assume prev awa = reduc)
  static       HidVarCPT2DModel<I,I,LogProb> mI_COPY; // Cached I_COPY model  --  WARNING: STATIC NON-CONST is not thread safe!
  static const HidVarCPT1DModel<F,LogProb>   mF_NOC;  // Fixed F_NOC model.
  static const HidVarCPT1DModel<F,LogProb>   mF_LEX;  // Fixed F_LEX model.
  static const HidVarCPT1DModel<I,LogProb>   mI_NIL;  // Fixed I_NIL model.
 public:
  //static bool Rd_ROOT_OBS;
  LogProb setIterProb ( Rd::ArrayIterator<LogProb>& rd, const D& d, const Rd& rdD, const Sd& sdP, const Sd& sdU, bool b1, int& vctr ) const {
    LogProb pr;
    if ( rdD==Rd_LEX && (sdP.getAwa().first==G_LEX) ) {
      // >1 (bottom) case...
      pr  = mF_LEX.setIterProb(rd.setF(),vctr);
      pr *= mI_NIL.setIterProb(rd.setI(),vctr);
    }
    //else if ( rdD>Rd_1 && (sdP.getAwa()==Rd(rdD).getG() || (sdP.getAwa().getTerm()==B_1 && rdD==Rd_LEX)) ) {
    else if ( rdD==Rd_LEX && sdP.getAwa().first.getTerm()==B_1 ) {
      // >1 (middle) case...
      pr  = mFr.setIterProb(rd.setF(),d,sdP.first,sdU.getAwa(),vctr);
      if ( vctr<-1 && pr==LogProb() ) cerr<<"\nERROR: no condition Fr "<<d<<" "<<sdP.first.first<<" "<<sdU.getAwa().first<<"\n\n";
      if ( !mI_COPY.contains(sdP.getAct().getI()) ) mI_COPY.setProb(sdP.getAct().getI(),sdP.getAct().getI())=1.0;
      pr *= mI_COPY.setIterProb(rd.setI(),sdP.getAct().getI(),vctr);
    }
    //if ( rdD==Rd_0 || (sdP.getAwa()!=Rd(rdD).getG() && !(sdP.getAwa().getTerm()==B_1 && Rd(rdD).getG()==G_NONE)) ) ) {
    else {
      // 0 (top) case...
      pr  = mF_NOC.setIterProb(rd.setF(),vctr);
      pr *= mI_NIL.setIterProb(rd.setI(),vctr);
    }
    // Iterate again if result doesn't match root observation...
    if ( vctr>=-1 && d==D_1 && b1!=(F(rd.first).getB()==B_1) ) pr=LogProb();
    //cerr<<"    Rd "<<d<<" "<<rdD<<" "<<sdP<<" "<<sdU<<" : "<<rd<<" = "<<pr<<" ("<<vctr<<")\n";
    return pr;
  }
  friend pair<StringInput,RdModel*> operator>> ( StringInput si, RdModel& m ) { return pair<StringInput,RdModel*>(si,&m); }
  friend StringInput operator>> ( pair<StringInput,RdModel*> si_m, const char* psD ) {
    StringInput si;
    return ( (si=si_m.first>>"Fr " >>si_m.second->mFr >>psD)!=NULL ) ? si : StringInput(NULL);
  }
};
const HidVarCPT1DModel<F,LogProb> RdModel::mF_NOC(F_NOC);
const HidVarCPT1DModel<F,LogProb> RdModel::mF_LEX(F_LEX);
const HidVarCPT1DModel<I,LogProb> RdModel::mI_NIL(I_NIL);
HidVarCPT2DModel<I,I,LogProb>     RdModel::mI_COPY;
//bool RdModel::Rd_ROOT_OBS = false;


//// Model of Sd given D and Rd and Rd and Sd(from prev) and Sd(from above)
class SdModel {
 public:
  HidVarCPT3DModel<  G,D,GI,LogProb> mGe;       // Expansion model of G given    D, GI (from above)
  HidVarCPT4DModel<I,D,G,GI,LogProb> mIe;       // Expansion model of I given G, D, GI (from above)
 private:
  HidVarCPT4DModel<  G,D,Rd,GI,LogProb> mGtw;   // Awaited transition model of G (active) given    D, GI (from reduction), GI (awaited cat from prev)
  HidVarCPT4DModel<I,D,G,    I,LogProb> mItw;   // Awaited transition model of I (active) given G, D,                       I (awaited cat from prev)
  HidVarCPT4DModel<  G,D,Rd,GI,LogProb> mGtaa;  // Active Transition model of G (active) given    D, GI (from reduction), GI (awaited cat from above)
  HidVarCPT5DModel<I,D,G,Rd,GI,LogProb> mItaa;  // Active Transition model of I (active) given G, D, GI (from reduction), GI (awaited cat from above)
  HidVarCPT4DModel<  G,D,Rd,GI,LogProb> mGtaw;  // Active Transition completion of G (awaited) given    D, GI (from reduction), GI (from curr active)
  HidVarCPT4DModel<I,D,G,    I,LogProb> mItaw;  // Active Transition completion of I (awaited) given G, D,                       I (from curr active)
  static const HidVarCPT1DModel<G,LogProb>   mG_LEX;   // Fixed G_LEX model.
  static const HidVarCPT1DModel<I,LogProb>   mI_NIL;   // Fixed I_NIL model.
  static       HidVarCPT2DModel<G,G,LogProb> mG_COPY;  // Cached G_COPY model  --  WARNING: STATIC NON-CONST is not thread safe!
  static       HidVarCPT2DModel<I,I,LogProb> mI_COPY;  // Cached I_COPY model  --  WARNING: STATIC NON-CONST is not thread safe!
 public:
  LogProb setIterProb ( Sd::ArrayIterator<LogProb>& sd, const D& d, const Rd& rdD, const Rd& rd, const Sd& sdP, const Sd& sdU, int& vctr ) const {
    LogProb pr,p;
    if (rdD.getF().getB()!=B_0) {
      if (rd.getF()!=F_NOC) {
        if (rd.getF().getB()==B_1) {
          if (sdU.getAwa().getG().getTerm()==B_1 || sdU==Sd_LEX) {
            ////cerr<<"vctr\n";
            // >1 >1 (expansion to null) case:
            pr  = mG_LEX.setIterProb(sd.setAct().setG(),vctr);
            pr *= mI_NIL.setIterProb(sd.setAct().setI(),vctr);
            pr *= mG_LEX.setIterProb(sd.setAwa().setG(),vctr);
            pr *= mI_NIL.setIterProb(sd.setAwa().setI(),vctr);
          }
          else {
            ////cerr<<"b\n";
            // >1 >1 (expansion) case:
            pr  = p = mGe.setIterProb(                       sd.setAct().setG() ,d,sdU.getAwa(),vctr);
            if ( vctr<-1 && p==LogProb() ) cerr<<"\nERROR: no condition Ge "                            <<d<<" "<<sdU.getAwa()<<"\n\n";
            pr *= p = mIe.setIterProb(sd.setAct().setI(),d,G(sd.setAct().setG()),  sdU.getAwa(),vctr);
            if ( vctr<-1 && p==LogProb() ) cerr<<"\nERROR: no condition Ie "<<d<<" "<<G(sd.setAct().setG())<<" "<<sdU.getAwa()<<"\n\n";
            if ( !mG_COPY.contains(G(sd.setAct().setG())) ) mG_COPY.setProb(G(sd.setAct().setG()),G(sd.setAct().setG()))=1.0;
            pr *= p = mG_COPY.setIterProb(sd.setAwa().setG(),G(sd.setAct().setG()),vctr);
            if ( !mI_COPY.contains(I(sd.setAct().setI())) ) mI_COPY.setProb(I(sd.setAct().setI()),I(sd.setAct().setI()))=1.0;
            pr *= p = mI_COPY.setIterProb(sd.setAwa().setI(),I(sd.setAct().setI()),vctr);
          }
        }
        else {
          ////cerr<<"c\n";
          // >1 1 (active transition following reduction) case:
          pr  = p = mGtaa.setIterProb(                       sd.setAct().setG() ,d,rd,sdU.getAwa(),vctr);
          if ( vctr<-1 && p==LogProb() ) cerr<<"\nERROR: no condition Gtaa "                            <<d<<" "<<rd<<" "<<sdU.getAwa()<<"\n\n";
          pr *= p = mItaa.setIterProb(sd.setAct().setI(),d,G(sd.setAct().setG()),  rd,sdU.getAwa(),vctr);
          if ( vctr<-1 && p==LogProb() ) cerr<<"\nERROR: no condition Itaa "<<d<<" "<<G(sd.setAct().setG())<<" "<<rd<<" "<<sdU.getAwa()<<"\n\n";
          pr *= p = mGtaw.setIterProb(                       sd.setAwa().setG() ,d,rd,GI(sd.setAct())      ,vctr);
          if ( vctr<-1 && p==LogProb() ) cerr<<"\nERROR: no condition Gtaw "                            <<d<<" "<<rd<<" "<<GI(sd.setAct())      <<"\n\n";
          pr *= p = mItaw.setIterProb(sd.setAwa().setI(),d,G(sd.setAwa().setG()),     I(sd.setAct().setI()),vctr);
          if ( vctr<-1 && p==LogProb() ) cerr<<"\nERROR: no condition Itaw "<<d<<" "<<G(sd.setAwa().setG())         <<" "<<I(sd.setAct().setI())<<"\n\n";
        }
      }
      else {
        ////cerr<<"d\n";
        // >1 0 (awaited transition without reduction) case:
        if ( !mG_COPY.contains(sdP.getAct().getG()) ) mG_COPY.setProb(sdP.getAct().getG(),sdP.getAct().getG())=1.0;
        pr  = p = mG_COPY.setIterProb(sd.setAct().setG(),sdP.getAct().getG(),vctr);
        if ( !mI_COPY.contains(sdP.getAct().getI()) ) mI_COPY.setProb(sdP.getAct().getI(),sdP.getAct().getI())=1.0;
        pr *= p = mI_COPY.setIterProb(sd.setAct().setI(),sdP.getAct().getI(),vctr);
        pr *= p = mGtw.setIterProb(                       sd.setAwa().setG() ,d,rdD,sdP.getAwa()       ,vctr);
        if ( vctr<-1 && p==LogProb() ) cerr<<"\nERROR: no condition Gtw "                            <<d<<" "<<rdD<<" "<<sdP.getAwa()       <<"\n\n";
        pr *= p = mItw.setIterProb(sd.setAwa().setI(),d,G(sd.setAwa().setG()),      sdP.getAwa().getI(),vctr);
        if ( vctr<-1 && p==LogProb() ) cerr<<"\nERROR: no condition Itw "<<d<<" "<<G(sd.setAwa().setG())<<" "          <<sdP.getAwa().getI()<<"\n\n";
      }
    }
    else {
      ////cerr<<"e\n";
      // <=1 0 (copy) case:
      if ( !mG_COPY.contains(sdP.getAct().getG()) )  mG_COPY.setProb(sdP.getAct().getG(), sdP.getAct().getG() )=1.0;
      pr  = p = mG_COPY.setIterProb(sd.setAct().setG(), sdP.getAct().getG(), vctr);
      if ( !mI_COPY.contains(sdP.getAct().getI()) )  mI_COPY.setProb(sdP.getAct().getI(), sdP.getAct().getI() )=1.0;
      pr *= p = mI_COPY.setIterProb(sd.setAct().setI(), sdP.getAct().getI(), vctr);
      if ( !mG_COPY.contains(sdP.getAwa().getG()) ) mG_COPY.setProb(sdP.getAwa().getG(),sdP.getAwa().getG())=1.0;
      pr *= p = mG_COPY.setIterProb(sd.setAwa().setG(),sdP.getAwa().getG(),vctr);
      if ( !mI_COPY.contains(sdP.getAwa().getI()) ) mI_COPY.setProb(sdP.getAwa().getI(),sdP.getAwa().getI())=1.0;
      pr *= p = mI_COPY.setIterProb(sd.setAwa().setI(),sdP.getAwa().getI(),vctr);
    }
    //cerr<<"    Sd "<<d<<" "<<rdD<<" "<<rd<<" "<<sdP<<" "<<sdU<<" : "<<sd<<" = "<<pr<<" ("<<vctr<<")\n";
    return pr;
  }
  friend pair<StringInput,SdModel*> operator>> ( StringInput si, SdModel& m ) { return pair<StringInput,SdModel*>(si,&m); }
  friend StringInput operator>> ( pair<StringInput,SdModel*> si_m, const char* psD ) {
    StringInput si;
    return ( (si=si_m.first>>"Gtw ">>si_m.second->mGtw>>psD)!=NULL ||
             (si=si_m.first>>"Itw ">>si_m.second->mItw>>psD)!=NULL ||
             (si=si_m.first>>"Gtaa ">>si_m.second->mGtaa>>psD)!=NULL ||
             (si=si_m.first>>"Itaa ">>si_m.second->mItaa>>psD)!=NULL ||
             (si=si_m.first>>"Gtaw ">>si_m.second->mGtaw>>psD)!=NULL ||
             (si=si_m.first>>"Itaw ">>si_m.second->mItaw>>psD)!=NULL ||
             (si=si_m.first>>"Ge ">>si_m.second->mGe>>psD)!=NULL ||
             (si=si_m.first>>"Ie ">>si_m.second->mIe>>psD)!=NULL ) ? si : StringInput(NULL);
  }
};
const HidVarCPT1DModel<G,LogProb> SdModel::mG_LEX(G_LEX);
const HidVarCPT1DModel<I,LogProb> SdModel::mI_NIL(I_NIL);
HidVarCPT2DModel<G,G,LogProb> SdModel::mG_COPY;
HidVarCPT2DModel<I,I,LogProb> SdModel::mI_COPY;


//////////////////////////////////////// Joint models...

//////////////////// Reduce phase...

//// Model of R given S
class RModel : public SingleFactoredModel<RdModel> {
 public:
  LogProb setIterProb ( R::ArrayIterator<LogProb>& r, const S& sP, bool b1, int& vctr ) const {
    const RdModel& mRd = getM1();
    LogProb pr;
    pr  = mRd.setIterProb ( r.set(4-1), 4, Rd(sP.second) , sP.first.get(4-1), sP.first.get(3-1), b1, vctr );
    pr *= mRd.setIterProb ( r.set(3-1), 3, Rd(r.get(4-1)), sP.first.get(3-1), sP.first.get(2-1), b1, vctr );
    pr *= mRd.setIterProb ( r.set(2-1), 2, Rd(r.get(3-1)), sP.first.get(2-1), sP.first.get(1-1), b1, vctr );
    pr *= mRd.setIterProb ( r.set(1-1), 1, Rd(r.get(2-1)), sP.first.get(1-1), Sd_TOP           , b1, vctr );
    return pr;
  }
};


//////////////////// Shift phase...

//// Model of S given R and S
class SModel : public SingleFactoredModel<SdModel> {
 private:
  static const HidVarCPT1DModel<G,LogProb>   mG_LEX;
  static const HidVarCPT1DModel<I,LogProb>   mI_NIL;
 public:
  LogProb setIterProb ( S::ArrayIterator<LogProb>& s, const R::ArrayIterator<LogProb>& r, const S& sP, int& vctr ) const {
    const SdModel& mSd = getM1();
    LogProb pr,p;
    pr  = mSd.setIterProb ( s.first.set(1-1), 1, Rd(r.get(2-1)), Rd(r.get(1-1)), sP.first.get(1-1), Sd_TOP               ,vctr );
    pr *= mSd.setIterProb ( s.first.set(2-1), 2, Rd(r.get(3-1)), Rd(r.get(2-1)), sP.first.get(2-1), Sd(s.first.set(1-1)) ,vctr );
    pr *= mSd.setIterProb ( s.first.set(3-1), 3, Rd(r.get(4-1)), Rd(r.get(3-1)), sP.first.get(3-1), Sd(s.first.set(2-1)) ,vctr );
    pr *= mSd.setIterProb ( s.first.set(4-1), 4, Rd(sP.second) , Rd(r.get(4-1)), sP.first.get(4-1), Sd(s.first.set(3-1)) ,vctr );
    if ( GI(s.first.set(4-1).second)!=GI_LEX &&
         GI(s.first.set(4-1).second).getG().getTerm()!=B_1 ) {
      pr *= p = mSd.mGe.setIterProb (                       s.second.setG(), 5, GI(s.first.set(4-1).second), vctr );
      if ( vctr<-1 && p==LogProb() ) cerr<<"\nERROR: no condition Ge 5 "                         <<GI(s.first.set(4-1).second)<<"\n\n";
      pr *= p = mSd.mIe.setIterProb ( s.second.setI(), 5, G(s.second.setG()),   GI(s.first.set(4-1).second), vctr );
      if ( vctr<-1 && p==LogProb() ) cerr<<"\nERROR: no condition Ie 5 "<<G(s.second.setG())<<" "<<GI(s.first.set(4-1).second)<<"\n\n";
    } else {
      pr *= mG_LEX.setIterProb ( s.second.setG(), vctr );
      pr *= mI_NIL.setIterProb ( s.second.setI(), vctr );
    }
    ////cerr<<"  G "<<5<<" "<<G(sd4.second)<<" : "<<g<<" = "<<pr<<" ("<<vctr<<")\n";
    return pr;
  }
};
const HidVarCPT1DModel<G,LogProb> SModel::mG_LEX(G_LEX);
const HidVarCPT1DModel<I,LogProb> SModel::mI_NIL(I_NIL);


//////////////////// Overall...

//// Model of Y=R,S given S
class YModel : public DoubleFactoredModel<RModel,SModel> {
 public:
  typedef Y::ArrayIterator<LogProb> IterVal;
  S& setTrellDat ( S& s, const Y::ArrayIterator<LogProb>& y ) const {
    s.setVal(y.second);
    return s;
  }
  R setBackDat ( const Y::ArrayIterator<LogProb>& y ) const {
    R r;
    for(int i=0;i<4;i++)
      r.set(i)=Rd(y.first.get(i));
    return r;
  }
  LogProb setIterProb ( Y::ArrayIterator<LogProb>& y, const S& sP, const X& x, bool b1, int& vctr ) const {
    const RModel& mR = getM1();
    const SModel& mS = getM2();
    LogProb pr;
    pr  = mR.setIterProb ( y.first, sP, b1, vctr );
    if ( LogProb()==pr ) return pr;
    pr *= mS.setIterProb ( y.second, y.first, sP, vctr );
    return pr;
  }
  void update ( ) const { }
};
