Index: moses/src/StaticData.cpp
===================================================================
--- moses/src/StaticData.cpp	(revision 3739)
+++ moses/src/StaticData.cpp	(working copy)
@@ -41,6 +41,10 @@
 #include "DecodeGraph.h"
 #include "InputFileStream.h"
 
+#ifdef HAVE_SYNLM
+#include "SyntacticLanguageModel.h"
+#endif
+
 using namespace std;
 
 namespace Moses
@@ -434,6 +438,12 @@
 		UserMessage::Add("invalid xml-input value, must be pass-through, exclusive, inclusive, or ignore");
 		return false;
 	}
+
+#ifdef HAVE_SYNLM
+	if (m_parameter->GetParam("slmodel-file").size() > 0) {
+	  if (!LoadSyntacticLanguageModel()) return false;
+	}
+#endif
 	
 	if (!LoadLexicalReorderingModel()) return false;
 	if (!LoadLanguageModels()) return false;
@@ -523,7 +533,11 @@
 
     
     //Add any other features here.
-    
+#ifdef HAVE_SYNLM
+    if (m_syntacticLanguageModel != NULL) {
+      m_translationSystems.find(config[0])->second.AddFeatureFunction(m_syntacticLanguageModel);
+    }
+#endif
   }
   
 
@@ -560,6 +574,12 @@
 	RemoveAllInColl(m_generationDictionary);
 	RemoveAllInColl(m_reorderModels);
 	RemoveAllInColl(m_globalLexicalModels);
+	
+#ifdef HAVE_SYNLM
+	delete m_syntacticLanguageModel;
+#endif
+
+
     RemoveAllInColl(m_decodeGraphs);
     RemoveAllInColl(m_wordPenaltyProducers);
     RemoveAllInColl(m_distortionScoreProducers);
@@ -583,6 +603,61 @@
 
 }
 
+#ifdef HAVE_SYNLM
+  bool StaticData::LoadSyntacticLanguageModel() {
+    cerr << "Loading syntactic language models..." << std::endl;
+    
+    const vector<float> weights = Scan<float>(m_parameter->GetParam("weight-slm"));
+    const vector<string> files = m_parameter->GetParam("slmodel-file");
+    
+    const FactorType factorType = (m_parameter->GetParam("slmodel-factor").size() > 0) ?
+      TransformScore(Scan<int>(m_parameter->GetParam("slmodel-factor")[0]))
+      : 0;
+
+    const size_t beamWidth = (m_parameter->GetParam("slmodel-beam").size() > 0) ?
+      TransformScore(Scan<int>(m_parameter->GetParam("slmodel-beam")[0]))
+      : 500;
+
+    if (files.size() < 1) {
+      cerr << "No syntactic language model files specified!" << std::endl;
+      return false;
+    }
+
+    // check if feature is used
+    if (weights.size() >= 1) {
+
+      //cout.setf(ios::scientific,ios::floatfield);
+      //cerr.setf(ios::scientific,ios::floatfield);
+      
+      // create the feature
+      m_syntacticLanguageModel = new SyntacticLanguageModel(files,weights,factorType,beamWidth); 
+
+      /* 
+      /////////////////////////////////////////
+      // BEGIN LANE's UNSTABLE EXPERIMENT :)
+      //
+
+      double ppl = m_syntacticLanguageModel->perplexity();
+      cerr << "Probability is " << ppl << endl;
+
+
+      //
+      // END LANE's UNSTABLE EXPERIMENT
+      /////////////////////////////////////////
+      */
+
+
+      if (m_syntacticLanguageModel==NULL) {
+	return false;
+      }
+
+    }
+    
+    return true;
+
+  }
+#endif
+
 bool StaticData::LoadLexicalReorderingModel()
 {
     VERBOSE(1, "Loading lexical distortion models...");
