/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser;

import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.syntaxgraph.DependencyGraph;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.core.syntaxgraph.edge.Edge;
import org.maltparser.core.syntaxgraph.edge.GraphEdge;
import org.maltparser.parser.Algorithm;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.SingleMalt;
import org.maltparser.parser.Trainer;
import org.maltparser.parser.algorithm.twoplanar3T.TwoPlanar3TConfig;
import org.maltparser.parser.algorithm.ucovington.UcovingtonConfig;
import org.maltparser.parser.guide.ClassifierGuide;
import org.maltparser.parser.guide.OracleGuide;
import org.maltparser.parser.guide.SingleGuide;
import org.maltparser.parser.history.GuideHistory;
import org.maltparser.parser.history.action.GuideDecision;
import org.maltparser.parser.history.action.GuideUserAction;

public class BatchTrainer
extends Trainer {
    private OracleGuide oracleGuide;
    private int parseCount;

    public BatchTrainer(DependencyParserConfig manager) throws MaltChainedException {
        super(manager);
        ((SingleMalt)manager).addRegistry(Algorithm.class, this);
        this.setManager(manager);
        this.initParserState(1);
        this.setGuide(new SingleGuide(manager, (GuideHistory)((Object)this.parserState.getHistory()), ClassifierGuide.GuideMode.BATCH));
        this.oracleGuide = this.parserState.getFactory().makeOracleGuide(this.parserState.getHistory());
    }

    public DependencyStructure parse(DependencyStructure goldDependencyGraph, DependencyStructure parseDependencyGraph) throws MaltChainedException {
        String opcion = "label";
        if (this.parserState.getTransitionSystem().getName().compareTo("two-planar 3t arc-eager") == 0) {
            opcion = ((TwoPlanar3TConfig)this.parserState.getConfiguration()).getMode();
        }
        if (this.parserState.getTransitionSystem().getName().compareTo("ucovnonproj") == 0) {
            opcion = ((UcovingtonConfig)this.parserState.getConfiguration()).getMode();
        }
        if (opcion.compareTo("root") == 0) {
            this.parserState.clear();
            this.parserState.initialize(parseDependencyGraph);
            if (this.parserState.getTransitionSystem().getName().compareTo("planar 3t arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("two-planar 3t arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("ucovnonproj") == 0) {
                ((DependencyGraph)parseDependencyGraph).setSingleHeadedConstraint(false);
                this.dependencyTreeToRigthGraph(goldDependencyGraph);
            }
            if (this.parserState.getTransitionSystem().getName().compareTo("planar 3t label strategy arc-eager") == 0) {
                ((DependencyGraph)parseDependencyGraph).setSingleHeadedConstraint(false);
                this.depTreeToLabeledUndirectedGraph(goldDependencyGraph);
            }
            this.currentParserConfiguration = this.parserState.getConfiguration();
            ++this.parseCount;
            if (this.diagnostics) {
                this.writeToDiaFile(this.parseCount + "");
            }
            while (!this.parserState.isTerminalState()) {
                GuideUserAction action = this.parserState.getTransitionSystem().getDeterministicAction(this.parserState.getHistory(), this.currentParserConfiguration);
                if (action == null) {
                    action = this.oracleGuide.predict(goldDependencyGraph, this.currentParserConfiguration);
                    try {
                        this.classifierGuide.addInstance((GuideDecision)((Object)action));
                    }
                    catch (NullPointerException e) {
                        throw new MaltChainedException("The guide cannot be found. ", e);
                    }
                } else if (this.diagnostics) {
                    this.writeToDiaFile(" *");
                }
                if (this.diagnostics) {
                    this.writeToDiaFile(" " + this.parserState.getTransitionSystem().getActionString(action));
                }
                this.parserState.apply(action);
            }
            if (this.parserState.getTransitionSystem().getName().compareTo("planar 3t arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("planar 3t label strategy arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("two-planar 3t arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("ucovnonproj") == 0) {
                this.copyEdgesForPlanar3T(this.currentParserConfiguration.getDependencyGraph(), parseDependencyGraph);
            } else {
                this.copyEdges(this.currentParserConfiguration.getDependencyGraph(), parseDependencyGraph);
            }
            parseDependencyGraph.linkAllTreesToRoot();
            this.oracleGuide.finalizeSentence(parseDependencyGraph);
            if (this.diagnostics) {
                this.writeToDiaFile("\n");
            }
            return parseDependencyGraph;
        }
        this.parserState.clear();
        this.parserState.initialize(parseDependencyGraph);
        if (this.parserState.getTransitionSystem().getName().compareTo("planar 3t arc-eager") == 0) {
            ((DependencyGraph)parseDependencyGraph).setSingleHeadedConstraint(false);
            this.dependencyTreeToRigthGraph(goldDependencyGraph);
        }
        if (this.parserState.getTransitionSystem().getName().compareTo("planar 3t label strategy arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("two-planar 3t arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("ucovnonproj") == 0) {
            ((DependencyGraph)parseDependencyGraph).setSingleHeadedConstraint(false);
            this.depTreeToLabeledUndirectedGraph(goldDependencyGraph);
        }
        this.currentParserConfiguration = this.parserState.getConfiguration();
        ++this.parseCount;
        if (this.diagnostics) {
            this.writeToDiaFile(this.parseCount + "");
        }
        while (!this.parserState.isTerminalState()) {
            GuideUserAction action = this.parserState.getTransitionSystem().getDeterministicAction(this.parserState.getHistory(), this.currentParserConfiguration);
            if (action == null) {
                action = this.oracleGuide.predict(goldDependencyGraph, this.currentParserConfiguration);
                try {
                    this.classifierGuide.addInstance((GuideDecision)((Object)action));
                }
                catch (NullPointerException e) {
                    throw new MaltChainedException("The guide cannot be found. ", e);
                }
            } else if (this.diagnostics) {
                this.writeToDiaFile(" *");
            }
            if (this.diagnostics) {
                this.writeToDiaFile(" " + this.parserState.getTransitionSystem().getActionString(action));
            }
            this.parserState.apply(action);
        }
        if (this.parserState.getTransitionSystem().getName().compareTo("planar 3t arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("planar 3t label strategy arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("two-planar 3t arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("ucovnonproj") == 0) {
            this.copyEdgesForPlanar3T(this.currentParserConfiguration.getDependencyGraph(), parseDependencyGraph);
        } else {
            this.copyEdges(this.currentParserConfiguration.getDependencyGraph(), parseDependencyGraph);
        }
        parseDependencyGraph.linkAllTreesToRoot();
        this.oracleGuide.finalizeSentence(parseDependencyGraph);
        if (this.diagnostics) {
            this.writeToDiaFile("\n");
        }
        return parseDependencyGraph;
    }

    public OracleGuide getOracleGuide() {
        return this.oracleGuide;
    }

    public void train() throws MaltChainedException {
    }

    public void terminate() throws MaltChainedException {
        if (this.diagnostics) {
            this.closeDiaWriter();
        }
    }

    private void dependencyTreeToRigthGraph(DependencyStructure graph) throws MaltChainedException {
        TreeSet<Edge> nuevosArcos = new TreeSet<Edge>();
        SortedSet<Edge> arcos = graph.getEdges();
        for (Edge arco : arcos) {
            if (arco.getTarget().getIndex() >= arco.getSource().getIndex()) continue;
            nuevosArcos.add(arco);
        }
        for (Edge ne : nuevosArcos) {
            ((GraphEdge)ne).changeSense(ne.getTarget(), ne.getSource(), 1);
        }
    }

    private void depTreeToLabeledUndirectedGraph(DependencyStructure graph) throws MaltChainedException {
        SortedSet<Edge> edges = graph.getEdges();
        for (Edge edge : edges) {
            Set<String> names = graph.getSymbolTables().getSymbolTableNames();
            for (String name : names) {
                if (name.compareTo("DEPREL") != 0) continue;
                String label = edge.getLabelSymbol(graph.getSymbolTables().getSymbolTable(name));
                label = edge.getSource().getIndex() < edge.getTarget().getIndex() ? label + "R" : label + "L";
                edge.addLabel(graph.getSymbolTables().getSymbolTable(name), label);
            }
        }
    }
}

