"""
The Program that loads the dialog output and evaluate the Diversity of Response.
"""
import json
import os

dialog_output_dir = "/home/zmykevin/multimodal_dialog/code/Deep-Reinforcement-Learning-Visual-Dialog/dialog_output/results"
dialog_output_path = os.path.join(dialog_output_dir, "results.json")

# Load the Dialog Output
with open(dialog_output_path, 'r') as f:
    json_data = f.read()
    dialog_output = json.loads(json_data)

Unique_Response_List = []
print(len(dialog_output['data']))
for current_data in dialog_output['data']:
    current_dialog = current_data['dialog']
    num_unique_response = []
    for turn in current_dialog:
        if turn['question'] not in num_unique_response:
            num_unique_response.append(turn['question'])
    Unique_Response_List.append(len(num_unique_response))
# Compute the Mean of Unique_Response_List
Mean_Diversity = sum(Unique_Response_List) / len(Unique_Response_List)
print("The Diversity fot this Dialog is: {}".format(Mean_Diversity))
