/*
 * Decompiled with CFR 0.152.
 */
package util;

import util.Utility;

public class NAirs {
    private static int absoluteMax = 15;
    int max;
    int[][][][] nair;
    boolean noDiscontinuous;

    public NAirs(int max) {
        this(max, false);
    }

    public NAirs(int max, boolean noDiscontinuous) {
        this.noDiscontinuous = noDiscontinuous;
        if (max > absoluteMax) {
            max = absoluteMax;
        }
        this.max = max;
        this.initNair();
    }

    private void initNair() {
        this.nair = new int[this.max + 1][this.max + 1][][];
        this.fillNairWithNulls();
        if (this.noDiscontinuous) {
            int c = 1;
            while (c <= this.max) {
                int n = 1;
                while (n <= c) {
                    this.nair[c][n] = Utility.n_air(c, n);
                    ++n;
                }
                ++c;
            }
        } else {
            int c = 1;
            while (c <= this.max) {
                int n = 1;
                while (n <= c) {
                    this.nair[c][n] = Utility.n_air_continuous(c, n);
                    ++n;
                }
                ++c;
            }
        }
    }

    private void fillNairWithNulls() {
        int i = 0;
        while (i <= this.max) {
            int j = 0;
            while (j <= this.max) {
                this.nair[i][j] = null;
                ++j;
            }
            ++i;
        }
    }

    public int[][] get(int c, int n) {
        return this.nair[c][n];
    }

    public static void main(String[] args) {
        NAirs N = new NAirs(10);
        int c = 0;
        while (c <= 10) {
            int n = 0;
            while (n <= c) {
                System.out.println("Nair\t" + c + "\t" + n);
                Utility.printIntArray(N.get(c, n));
                System.out.println();
                ++n;
            }
            ++c;
        }
    }
}

