/*
 * Decompiled with CFR 0.152.
 */
package tsg.parsingExp;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import tsg.Label;
import tsg.TSNodeLabel;
import util.ArgumentReader;
import util.FileUtil;

public class MarkoBinarizationOld {
    static char binarizeLevelMarker = (char)42;
    static char catSeparation = (char)124;
    static char nullNode = (char)35;
    static boolean oldMarkoBinarization = false;
    public static int markH = 1;
    public static int markV = 1;
    public static boolean markovize = true;
    public static boolean binarize = true;

    public static void setHV(int h, int v) {
        markH = h;
        markV = v;
    }

    public static boolean isMarkoBinarizationActive() {
        return binarize || markovize;
    }

    public static ArrayList<TSNodeLabel> markoBinarizeTreebank(ArrayList<TSNodeLabel> treebank) {
        if (oldMarkoBinarization) {
            return MarkoBinarizationOld.oldMarkoBinarizeTreebank(treebank);
        }
        return MarkoBinarizationOld.newMarkoBinarizeTreebank(treebank);
    }

    public static TSNodeLabel undoMarkoBinarization(TSNodeLabel tree) {
        if (oldMarkoBinarization) {
            return MarkoBinarizationOld.oldUndoMarkoBinarization(tree);
        }
        return MarkoBinarizationOld.newUndoMarkoBinarization(tree);
    }

    public static TSNodeLabel markoBinarize(TSNodeLabel tree) {
        if (oldMarkoBinarization) {
            return MarkoBinarizationOld.leftBinarizeH1V1(tree);
        }
        TSNodeLabel result = MarkoBinarizationOld.markovizeTree(tree);
        result = MarkoBinarizationOld.leftBinarize(result);
        return result;
    }

    private static TSNodeLabel newUndoMarkoBinarization(TSNodeLabel tree) {
        tree = MarkoBinarizationOld.undoLeftBinarize(tree);
        tree = MarkoBinarizationOld.unmarkovizeTree(tree);
        return tree;
    }

    private static TSNodeLabel oldUndoMarkoBinarization(TSNodeLabel tree) {
        return MarkoBinarizationOld.undoLeftBinarizeH1V1(tree);
    }

    private static ArrayList<TSNodeLabel> newMarkoBinarizeTreebank(ArrayList<TSNodeLabel> treebank) {
        ArrayList<TSNodeLabel> result = new ArrayList<TSNodeLabel>();
        for (TSNodeLabel t : treebank) {
            t = MarkoBinarizationOld.markovizeTree(t);
            t = MarkoBinarizationOld.leftBinarize(t);
            result.add(t);
        }
        return result;
    }

    private static ArrayList<TSNodeLabel> oldMarkoBinarizeTreebank(ArrayList<TSNodeLabel> treebank) {
        ArrayList<TSNodeLabel> result = new ArrayList<TSNodeLabel>();
        for (TSNodeLabel t : treebank) {
            t = MarkoBinarizationOld.leftBinarizeH1V1(t);
            result.add(t);
        }
        return result;
    }

    public static TSNodeLabel markovizeTree(TSNodeLabel thisNode) {
        if (thisNode.isLexical) {
            TSNodeLabel result = new TSNodeLabel(thisNode.label, true);
            return result;
        }
        StringBuilder newLabel = new StringBuilder(thisNode.label());
        TSNodeLabel chainUp = thisNode;
        int i = 0;
        while (i < markV) {
            chainUp = chainUp == null ? null : chainUp.parent;
            newLabel.append(catSeparation);
            newLabel.append(chainUp == null ? Character.valueOf(nullNode) : chainUp.label());
            ++i;
        }
        newLabel.append(catSeparation);
        TSNodeLabel parent = thisNode.parent;
        if (parent == null) {
            int i2 = 0;
            while (i2 < markH) {
                newLabel.append(catSeparation);
                newLabel.append(nullNode);
                ++i2;
            }
        } else {
            int index = parent.indexOfDaughter(thisNode);
            int i3 = 0;
            while (i3 < markH) {
                newLabel.append(catSeparation);
                newLabel.append(--index < 0 ? Character.valueOf(nullNode) : parent.daughters[i3].label());
                ++i3;
            }
        }
        TSNodeLabel result = new TSNodeLabel(Label.getLabel(newLabel.toString()), false);
        int prole = thisNode.prole();
        TSNodeLabel[] newDaughters = new TSNodeLabel[prole];
        result.daughters = newDaughters;
        int i4 = 0;
        while (i4 < prole) {
            TSNodeLabel d = MarkoBinarizationOld.markovizeTree(thisNode.daughters[i4]);
            d.parent = result;
            newDaughters[i4] = d;
            ++i4;
        }
        return result;
    }

    public static TSNodeLabel unmarkovizeTree(TSNodeLabel thisNode) {
        if (thisNode.isLexical) {
            TSNodeLabel result = new TSNodeLabel(thisNode.label, true);
            return result;
        }
        String labelString = thisNode.label();
        int indexCatSeparation = labelString.indexOf(catSeparation);
        Label newLabel = Label.getLabel(labelString.substring(0, indexCatSeparation));
        TSNodeLabel result = new TSNodeLabel(newLabel, false);
        int prole = thisNode.prole();
        TSNodeLabel[] newDaughters = new TSNodeLabel[prole];
        result.daughters = newDaughters;
        int i = 0;
        while (i < prole) {
            TSNodeLabel d = MarkoBinarizationOld.unmarkovizeTree(thisNode.daughters[i]);
            d.parent = result;
            newDaughters[i] = d;
            ++i;
        }
        return result;
    }

    public static TSNodeLabel leftBinarize(TSNodeLabel thisNode) {
        int prole = thisNode.prole();
        TSNodeLabel binaryCopy = new TSNodeLabel(thisNode.label, thisNode.isLexical);
        if (prole == 0) {
            return binaryCopy;
        }
        if (prole == 1) {
            TSNodeLabel onlyDaughter = MarkoBinarizationOld.leftBinarize(thisNode.firstDaughter());
            binaryCopy.daughters = new TSNodeLabel[]{onlyDaughter};
            onlyDaughter.parent = binaryCopy;
            return binaryCopy;
        }
        TSNodeLabel left = thisNode.daughters[0];
        TSNodeLabel right = thisNode.daughters[1];
        if (prole == 2) {
            TSNodeLabel leftCopy = MarkoBinarizationOld.leftBinarize(left);
            TSNodeLabel rightCopy = MarkoBinarizationOld.leftBinarize(right);
            binaryCopy.daughters = new TSNodeLabel[]{leftCopy, rightCopy};
            leftCopy.parent = binaryCopy;
            rightCopy.parent = binaryCopy;
            return binaryCopy;
        }
        Label levelParentLabel = Label.getLabel(String.valueOf(thisNode.label()) + binarizeLevelMarker);
        TSNodeLabel levelParent = new TSNodeLabel(levelParentLabel, false);
        TSNodeLabel leftCopy = MarkoBinarizationOld.leftBinarize(left);
        TSNodeLabel rightCopy = MarkoBinarizationOld.leftBinarize(right);
        levelParent.daughters = new TSNodeLabel[]{leftCopy, rightCopy};
        leftCopy.parent = levelParent;
        rightCopy.parent = levelParent;
        int i = 2;
        while (i < prole) {
            TSNodeLabel newLevelParent = binaryCopy;
            if (i < prole - 1) {
                Label newLevelParentLabel = Label.getLabel(String.valueOf(thisNode.label()) + binarizeLevelMarker);
                newLevelParent = new TSNodeLabel(newLevelParentLabel, false);
            }
            right = thisNode.daughters[i];
            rightCopy = MarkoBinarizationOld.leftBinarize(right);
            newLevelParent.daughters = new TSNodeLabel[]{levelParent, rightCopy};
            levelParent.parent = newLevelParent;
            rightCopy.parent = newLevelParent;
            levelParent = newLevelParent;
            ++i;
        }
        return binaryCopy;
    }

    public static TSNodeLabel undoLeftBinarize(TSNodeLabel thisNode) {
        int prole = thisNode.prole();
        TSNodeLabel unbinaryCopy = new TSNodeLabel(thisNode.label, thisNode.isLexical);
        if (prole == 0) {
            return unbinaryCopy;
        }
        if (prole == 1) {
            TSNodeLabel onlyDaughter = MarkoBinarizationOld.undoLeftBinarize(thisNode.firstDaughter());
            unbinaryCopy.daughters = new TSNodeLabel[]{onlyDaughter};
            onlyDaughter.parent = unbinaryCopy;
            return unbinaryCopy;
        }
        ArrayList<TSNodeLabel> newDaughters = new ArrayList<TSNodeLabel>();
        TSNodeLabel currentLevel = thisNode;
        do {
            newDaughters.add(MarkoBinarizationOld.undoLeftBinarize(currentLevel.daughters[1]));
        } while ((currentLevel = currentLevel.daughters[0]).label().indexOf(binarizeLevelMarker) != -1);
        newDaughters.add(MarkoBinarizationOld.undoLeftBinarize(currentLevel));
        int newProle = newDaughters.size();
        unbinaryCopy.daughters = new TSNodeLabel[newProle];
        int i = newProle - 1;
        for (TSNodeLabel d : newDaughters) {
            unbinaryCopy.daughters[i--] = d;
            d.parent = unbinaryCopy;
        }
        return unbinaryCopy;
    }

    public static TSNodeLabel leftBinarizeH1V1(TSNodeLabel thisNode) {
        int prole = thisNode.prole();
        TSNodeLabel binaryCopy = new TSNodeLabel(thisNode.label, thisNode.isLexical);
        if (prole == 0) {
            return binaryCopy;
        }
        if (prole == 1) {
            TSNodeLabel onlyDaughter = MarkoBinarizationOld.leftBinarizeH1V1(thisNode.firstDaughter());
            binaryCopy.daughters = new TSNodeLabel[]{onlyDaughter};
            onlyDaughter.parent = binaryCopy;
            return binaryCopy;
        }
        TSNodeLabel left = thisNode.daughters[0];
        TSNodeLabel right = thisNode.daughters[1];
        if (prole == 2) {
            TSNodeLabel leftCopy = MarkoBinarizationOld.leftBinarizeH1V1(left);
            TSNodeLabel rightCopy = MarkoBinarizationOld.leftBinarizeH1V1(right);
            binaryCopy.daughters = new TSNodeLabel[]{leftCopy, rightCopy};
            leftCopy.parent = binaryCopy;
            rightCopy.parent = binaryCopy;
            return binaryCopy;
        }
        TSNodeLabel next = thisNode.daughters[2];
        Label levelParentLabel = Label.getLabel(String.valueOf(thisNode.label()) + catSeparation + next.label());
        TSNodeLabel levelParent = new TSNodeLabel(levelParentLabel, false);
        TSNodeLabel leftCopy = MarkoBinarizationOld.leftBinarizeH1V1(left);
        TSNodeLabel rightCopy = MarkoBinarizationOld.leftBinarizeH1V1(right);
        levelParent.daughters = new TSNodeLabel[]{leftCopy, rightCopy};
        leftCopy.parent = levelParent;
        rightCopy.parent = levelParent;
        int i = 2;
        while (i < prole) {
            TSNodeLabel newLevelParent = binaryCopy;
            if (i < prole - 1) {
                Label newLevelParentLabel = Label.getLabel(String.valueOf(thisNode.label()) + catSeparation + thisNode.daughters[i + 1].label());
                newLevelParent = new TSNodeLabel(newLevelParentLabel, false);
            }
            right = thisNode.daughters[i];
            rightCopy = MarkoBinarizationOld.leftBinarizeH1V1(right);
            newLevelParent.daughters = new TSNodeLabel[]{levelParent, rightCopy};
            levelParent.parent = newLevelParent;
            rightCopy.parent = newLevelParent;
            levelParent = newLevelParent;
            ++i;
        }
        return binaryCopy;
    }

    public static TSNodeLabel undoLeftBinarizeH1V1(TSNodeLabel thisNode) {
        int prole = thisNode.prole();
        TSNodeLabel unbinaryCopy = new TSNodeLabel(thisNode.label, thisNode.isLexical);
        if (prole == 0) {
            return unbinaryCopy;
        }
        if (prole == 1) {
            TSNodeLabel onlyDaughter = MarkoBinarizationOld.undoLeftBinarizeH1V1(thisNode.firstDaughter());
            unbinaryCopy.daughters = new TSNodeLabel[]{onlyDaughter};
            onlyDaughter.parent = unbinaryCopy;
            return unbinaryCopy;
        }
        ArrayList<TSNodeLabel> newDaughters = new ArrayList<TSNodeLabel>();
        TSNodeLabel currentLevel = thisNode;
        do {
            newDaughters.add(MarkoBinarizationOld.undoLeftBinarizeH1V1(currentLevel.daughters[1]));
        } while ((currentLevel = currentLevel.daughters[0]).label().indexOf(catSeparation) != -1);
        newDaughters.add(MarkoBinarizationOld.undoLeftBinarizeH1V1(currentLevel));
        int newProle = newDaughters.size();
        unbinaryCopy.daughters = new TSNodeLabel[newProle];
        int i = newProle - 1;
        for (TSNodeLabel d : newDaughters) {
            unbinaryCopy.daughters[i--] = d;
            d.parent = unbinaryCopy;
        }
        return unbinaryCopy;
    }

    public static void main1(String[] args) throws Exception {
        TSNodeLabel t = new TSNodeLabel("(A B C D E)");
        TSNodeLabel markoBinarizedTree = MarkoBinarizationOld.markoBinarize(t);
        System.out.println(markoBinarizedTree);
        System.out.println(markoBinarizedTree.checkParentDaughtersConsistency());
        System.out.println(markoBinarizedTree.checkOnlyAndAllTerminalsAreLexical());
        TSNodeLabel original = MarkoBinarizationOld.undoMarkoBinarization(markoBinarizedTree);
        System.out.println(original);
        System.out.println(original.checkParentDaughtersConsistency());
        System.out.println(original.checkOnlyAndAllTerminalsAreLexical());
    }

    public static void main(String[] args) throws Exception {
        String binarizeOption = "-binarize:";
        String markovH = "-markovH:";
        String markovV = "-markovV:";
        markH = 1;
        markV = 1;
        binarize = true;
        String usage = "USAGE: java [-Xmx1G] TreeMarkoBinarization[-markovH:1] [-markovV:1] [-binarize:true] inputFile outputFile";
        if (args.length < 2 || args.length > 9) {
            System.err.println("Incorrect number of arguments: " + args.length);
            System.err.println(usage);
            System.exit(-1);
        }
        int i = 0;
        while (i < args.length - 2) {
            String option;
            if ((option = args[i++]).startsWith(binarizeOption)) {
                binarize = ArgumentReader.readBooleanOption(option);
                continue;
            }
            if (option.startsWith(markovH)) {
                markH = ArgumentReader.readIntOption(option);
                continue;
            }
            if (!option.startsWith(markovV)) continue;
            markV = ArgumentReader.readIntOption(option);
        }
        File inputFile = new File(args[i++]);
        File outputFile = new File(args[i]);
        ArrayList<TSNodeLabel> treebank = TSNodeLabel.getTreebank(inputFile);
        PrintWriter pw = FileUtil.getPrintWriter(outputFile);
        boolean markovize = markH > 0 || markV > 0;
        for (TSNodeLabel t : treebank) {
            TSNodeLabel transformed1 = markovize ? MarkoBinarizationOld.markovizeTree(t) : t;
            TSNodeLabel transformed2 = binarize ? MarkoBinarizationOld.leftBinarize(transformed1) : transformed1;
            pw.println(transformed2.toString());
        }
        pw.close();
    }
}

