/*
 * Decompiled with CFR 0.152.
 */
package tsg.parsingExp;

import java.io.File;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeSet;
import java.util.Vector;
import tsg.TSNodeLabel;
import tsg.TSNodeLabelFreqDouble;
import util.FileUtil;

public class ConvertFragmentsToCFGRulesDouble {
    public Hashtable<String, TreeSet<TSNodeLabelFreqDouble>> ruleFragmentsTable;
    Vector<TSNodeLabel> ambiguousCFGmappingIndex;
    Hashtable<String, TSNodeLabel> unambiguousCFGmapping;
    File grammarFile;
    File ambiguousFragmentsFile;
    File outputFile;
    String internalFakeNodeLabel;
    String fakePrelexPrefix;

    public ConvertFragmentsToCFGRulesDouble(File grammarFile, File ambiguousFragmentsFile, File outputFile, String internalFakeNodeLabel, String fakePrelexPrefix) {
        this.grammarFile = grammarFile;
        this.ambiguousFragmentsFile = ambiguousFragmentsFile;
        this.outputFile = outputFile;
        this.internalFakeNodeLabel = internalFakeNodeLabel;
        this.fakePrelexPrefix = fakePrelexPrefix;
        this.buildRuleFragmentsTable();
        this.dismabiguateMappingAndPrintPCFG();
    }

    public Hashtable<String, TreeSet<TSNodeLabelFreqDouble>> getRuleFragmentsTable() {
        return this.ruleFragmentsTable;
    }

    public int getCFGtypes() {
        return this.ruleFragmentsTable.size();
    }

    public Vector<TSNodeLabel> getAmbiguousCFGmapping() {
        return this.ambiguousCFGmappingIndex;
    }

    public Hashtable<String, TSNodeLabel> getunambiguousCFGmapping() {
        return this.unambiguousCFGmapping;
    }

    private void buildRuleFragmentsTable() {
        this.ruleFragmentsTable = new Hashtable();
        Scanner scan = FileUtil.getScanner(this.grammarFile);
        while (scan.hasNextLine()) {
            String fragmentLine = scan.nextLine();
            String[] lineSplit = fragmentLine.split("\t");
            String fragmentString = lineSplit[0];
            double freq = Double.parseDouble(lineSplit[1]);
            TSNodeLabel fragment = null;
            try {
                fragment = new TSNodeLabel(fragmentString, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String treeCFGrule = this.compressToCFGRulePosLex(fragment);
            this.add(treeCFGrule, new TSNodeLabelFreqDouble(fragment, freq));
        }
    }

    private String compressToCFGRulePosLex(TSNodeLabel thisNode) {
        StringBuilder sb = new StringBuilder(thisNode.label());
        this.fillStringBuilderWithTerminalsPosLex(thisNode, sb);
        return sb.toString();
    }

    private void fillStringBuilderWithTerminalsPosLex(TSNodeLabel thisNode, StringBuilder sb) {
        if (thisNode.isLexical) {
            sb.append(" " + this.fakePrelexPrefix + thisNode.label());
            return;
        }
        if (thisNode.isTerminal()) {
            sb.append(" " + thisNode.label());
            return;
        }
        TSNodeLabel[] tSNodeLabelArray = thisNode.daughters;
        int n = thisNode.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            this.fillStringBuilderWithTerminalsPosLex(d, sb);
            ++n2;
        }
    }

    public void add(String treeCFGrule, TSNodeLabelFreqDouble treeFreq) {
        TreeSet<TSNodeLabelFreqDouble> value = this.ruleFragmentsTable.get(treeCFGrule);
        if (value == null) {
            value = new TreeSet();
            this.ruleFragmentsTable.put(treeCFGrule, value);
        }
        value.add(treeFreq);
    }

    private void dismabiguateMappingAndPrintPCFG() {
        this.ambiguousCFGmappingIndex = new Vector();
        this.unambiguousCFGmapping = new Hashtable();
        PrintWriter pwAmbiguous = FileUtil.getPrintWriter(this.ambiguousFragmentsFile);
        PrintWriter pwPCFG = FileUtil.getPrintWriter(this.outputFile);
        pwAmbiguous.println("List of rules mapping to multiple fragments:\n");
        int uniqueAmbiguousFragmentIndex = 0;
        for (Map.Entry<String, TreeSet<TSNodeLabelFreqDouble>> e : this.ruleFragmentsTable.entrySet()) {
            String cfgRule = e.getKey();
            TreeSet<TSNodeLabelFreqDouble> sortedFragmentsSet = e.getValue();
            if (sortedFragmentsSet.size() == 1) {
                TSNodeLabelFreqDouble uniqueFragmentFreq = sortedFragmentsSet.first();
                TSNodeLabel uniqueFragment = uniqueFragmentFreq.tree();
                double freq = uniqueFragmentFreq.freq();
                this.unambiguousCFGmapping.put(cfgRule, uniqueFragment);
                pwPCFG.println(String.valueOf(freq) + "\t" + cfgRule);
                continue;
            }
            pwAmbiguous.println(cfgRule);
            Iterator<TSNodeLabelFreqDouble> discIter = sortedFragmentsSet.descendingIterator();
            int firstSpace = cfgRule.indexOf(32);
            String lhs = cfgRule.substring(0, firstSpace);
            String rhs = cfgRule.substring(firstSpace + 1);
            while (discIter.hasNext()) {
                TSNodeLabelFreqDouble fragmentFreq = discIter.next();
                TSNodeLabel fragment = fragmentFreq.tree();
                double freq = fragmentFreq.freq();
                String uniqueLabel = String.valueOf(this.internalFakeNodeLabel) + uniqueAmbiguousFragmentIndex++;
                pwAmbiguous.println(String.valueOf(uniqueLabel) + "\t" + fragmentFreq.toString(false, true));
                this.ambiguousCFGmappingIndex.add(fragment);
                String firstRuleUnique = String.valueOf(lhs) + " " + uniqueLabel;
                String secondRuleUnique = String.valueOf(uniqueLabel) + " " + rhs;
                pwPCFG.println(String.valueOf(freq) + "\t" + firstRuleUnique);
                pwPCFG.println("1\t" + secondRuleUnique);
            }
            pwAmbiguous.println();
        }
        pwAmbiguous.close();
        pwPCFG.close();
    }

    public static void main(String[] args) throws Exception {
    }
}

