/*
 * Decompiled with CFR 0.152.
 */
package tsg.kernels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.ListIterator;
import settings.Parameters;
import tsg.Label;
import tsg.TSNodeLabel;
import util.Pair;

public class AllOrderedNodeSubSet {
    public static long maxComb = 1000L;
    boolean[][] equalMatrix;
    TSNodeLabel[] a1;
    TSNodeLabel[] a2;
    Cell[][] subSequencesMatrix;
    int[][] subSequencesSizeMatrix;
    int xMax;
    int yMax;
    int xLength;
    int yLength;
    int matched;

    public AllOrderedNodeSubSet(TSNodeLabel[] a1, TSNodeLabel[] a2) {
        this.a1 = a1;
        this.a2 = a2;
        this.initVariables();
    }

    public void initVariables() {
        this.xLength = this.a1.length;
        this.yLength = this.a2.length;
        this.xMax = this.a1.length - 1;
        this.yMax = this.a2.length - 1;
        this.equalMatrix = new boolean[this.xLength][this.yLength];
        this.subSequencesMatrix = new Cell[this.xLength][this.yLength];
        int i = 0;
        while (i < this.a1.length) {
            int j = 0;
            while (j < this.a2.length) {
                if (this.a1[i].sameLabel(this.a2[j])) {
                    this.equalMatrix[i][j] = true;
                    ++this.matched;
                }
                ++j;
            }
            ++i;
        }
        int[][] nArray = this.subSequencesSizeMatrix = new int[this.xLength][this.yLength];
        int n = this.subSequencesSizeMatrix.length;
        int n2 = 0;
        while (n2 < n) {
            int[] array = nArray[n2];
            Arrays.fill(array, -1);
            ++n2;
        }
    }

    public void reduceA1A2() {
        HashSet<Label> a1Set = new HashSet<Label>();
        HashSet<Label> a2Set = new HashSet<Label>();
        TSNodeLabel[] tSNodeLabelArray = this.a1;
        int n = this.a1.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel n1 = tSNodeLabelArray[n2];
            a1Set.add(n1.label);
            ++n2;
        }
        tSNodeLabelArray = this.a2;
        n = this.a2.length;
        n2 = 0;
        while (n2 < n) {
            TSNodeLabel n22 = tSNodeLabelArray[n2];
            a2Set.add(n22.label);
            ++n2;
        }
        a1Set.retainAll(a2Set);
        ArrayList<TSNodeLabel> l1 = new ArrayList<TSNodeLabel>(this.a1.length);
        ArrayList<TSNodeLabel> l2 = new ArrayList<TSNodeLabel>(this.a2.length);
        TSNodeLabel[] tSNodeLabelArray2 = this.a1;
        int n3 = this.a1.length;
        int n4 = 0;
        while (n4 < n3) {
            TSNodeLabel n1 = tSNodeLabelArray2[n4];
            if (a1Set.contains(n1.label)) {
                l1.add(n1);
            }
            ++n4;
        }
        tSNodeLabelArray2 = this.a2;
        n3 = this.a2.length;
        n4 = 0;
        while (n4 < n3) {
            TSNodeLabel n23 = tSNodeLabelArray2[n4];
            if (a1Set.contains(n23.label)) {
                l2.add(n23);
            }
            ++n4;
        }
        this.a1 = l1.toArray(new TSNodeLabel[l1.size()]);
        this.a2 = l2.toArray(new TSNodeLabel[l2.size()]);
        this.initVariables();
    }

    public static ArrayList<ArrayList<Pair<TSNodeLabel>>> allDaughtersMatchBackupOnSimple(TSNodeLabel t1, TSNodeLabel t2) {
        AllOrderedNodeSubSet O = new AllOrderedNodeSubSet(t1.daughters, t2.daughters);
        long comb = O.getNumberSubsequences();
        if (comb > maxComb) {
            Parameters.appendReturnInLogFile("Backup on siple match of daughteers. Max comb: " + comb + "\n\t" + t1.toString() + "\n\t" + t2.toString() + "\n");
            O.reduceA1A2();
            return O.getSimpleSubsequence();
        }
        return O.getAllSubsequences();
    }

    public static ArrayList<ArrayList<Pair<TSNodeLabel>>> allDaughtersMatch(TSNodeLabel t1, TSNodeLabel t2) {
        return new AllOrderedNodeSubSet(t1.daughters, t2.daughters).getAllSubsequences();
    }

    public static long allDaughtersMatchSize(TSNodeLabel t1, TSNodeLabel t2) {
        return new AllOrderedNodeSubSet(t1.daughters, t2.daughters).getNumberSubsequences();
    }

    public long getNumberSubsequences() {
        if (this.matched == 0) {
            return 0L;
        }
        long result = 0L;
        int ringX = 0;
        int ringY = 0;
        int lowY = this.yMax;
        int rightX = this.xMax;
        boolean ringNewXExists = ringX < this.xLength;
        boolean ringNewYExists = ringY < this.yLength;
        while (ringNewXExists || ringNewYExists) {
            if (ringNewXExists) {
                int cellY = lowY;
                while (cellY > ringY) {
                    if (this.equalMatrix[ringX][cellY]) {
                        lowY = cellY;
                        result += (long)this.getNumberSubsequences(ringX, cellY);
                    }
                    --cellY;
                }
            }
            if (ringNewYExists) {
                int cellX = rightX;
                while (cellX > ringX) {
                    if (this.equalMatrix[cellX][ringY]) {
                        rightX = cellX;
                        result += (long)this.getNumberSubsequences(cellX, ringY);
                    }
                    --cellX;
                }
            }
            if (ringNewXExists && ringNewYExists && this.equalMatrix[ringX][ringY]) {
                result += (long)this.getNumberSubsequences(ringX, ringY);
                break;
            }
            if (ringNewXExists) {
                if (ringX + 1 <= rightX) {
                    ++ringX;
                } else {
                    ringNewXExists = false;
                }
            }
            if (!ringNewYExists) continue;
            if (ringY + 1 <= lowY) {
                ++ringY;
                continue;
            }
            ringNewYExists = false;
        }
        return result;
    }

    private int getNumberSubsequences(int x, int y) {
        int stored = this.subSequencesSizeMatrix[x][y];
        if (stored != -1) {
            return stored;
        }
        stored = 0;
        int ringX = x + 1;
        int ringY = y + 1;
        int lowY = this.yMax;
        int rightX = this.xMax;
        boolean ringNewXExists = ringX < this.xLength;
        boolean ringNewYExists = ringY < this.yLength;
        while (ringNewXExists || ringNewYExists) {
            if (ringNewXExists) {
                int cellY = lowY;
                while (cellY > ringY) {
                    if (this.equalMatrix[ringX][cellY]) {
                        lowY = cellY;
                        stored += this.getNumberSubsequences(ringX, cellY);
                    }
                    --cellY;
                }
            }
            if (ringNewYExists) {
                int cellX = rightX;
                while (cellX > ringX) {
                    if (this.equalMatrix[cellX][ringY]) {
                        rightX = cellX;
                        stored += this.getNumberSubsequences(cellX, ringY);
                    }
                    --cellX;
                }
            }
            if (ringNewXExists && ringNewYExists && this.equalMatrix[ringX][ringY]) {
                stored += this.getNumberSubsequences(ringX, ringY);
                break;
            }
            if (ringNewXExists) {
                if (ringX + 1 <= rightX) {
                    ++ringX;
                } else {
                    ringNewXExists = false;
                }
            }
            if (!ringNewYExists) continue;
            if (ringY + 1 <= lowY) {
                ++ringY;
                continue;
            }
            ringNewYExists = false;
        }
        if (stored == 0) {
            stored = 1;
        }
        int n = stored;
        this.subSequencesSizeMatrix[x][y] = n;
        return n;
    }

    public ArrayList<ArrayList<Pair<TSNodeLabel>>> getSimpleSubsequence() {
        ArrayList<ArrayList<Pair<TSNodeLabel>>> result = new ArrayList<ArrayList<Pair<TSNodeLabel>>>();
        ArrayList<Pair<TSNodeLabel>> skipX = new ArrayList<Pair<TSNodeLabel>>();
        ArrayList<Pair<Integer>> skipXIndexes = new ArrayList<Pair<Integer>>();
        int j = 0;
        int i = 0;
        while (i < this.xLength) {
            if (this.equalMatrix[i][j]) {
                skipX.add(new Pair<TSNodeLabel>(this.a1[i], this.a2[j]));
                skipXIndexes.add(new Pair<Integer>(i, j));
                if (++j == this.yLength) break;
            }
            ++i;
        }
        ArrayList<Pair<TSNodeLabel>> skipY = new ArrayList<Pair<TSNodeLabel>>();
        ArrayList<Pair<Integer>> skipYIndexes = new ArrayList<Pair<Integer>>();
        int i2 = 0;
        j = 0;
        while (j < this.yLength) {
            if (this.equalMatrix[i2][j]) {
                skipY.add(new Pair<TSNodeLabel>(this.a1[i2], this.a2[j]));
                skipYIndexes.add(new Pair<Integer>(i2, j));
                if (++i2 == this.xLength) break;
            }
            ++j;
        }
        result.add(skipX);
        if (skipXIndexes.equals(skipYIndexes)) {
            return result;
        }
        result.add(skipY);
        return result;
    }

    public ArrayList<ArrayList<Pair<TSNodeLabel>>> getAllSubsequences() {
        if (this.matched == 0) {
            return null;
        }
        ArrayList<ArrayList<Pair<TSNodeLabel>>> result = new ArrayList<ArrayList<Pair<TSNodeLabel>>>();
        int ringX = 0;
        int ringY = 0;
        int lowY = this.yMax;
        int rightX = this.xMax;
        boolean ringNewXExists = ringX < this.xLength;
        boolean ringNewYExists = ringY < this.yLength;
        while (ringNewXExists || ringNewYExists) {
            if (ringNewXExists) {
                int cellY = lowY;
                while (cellY > ringY) {
                    if (this.equalMatrix[ringX][cellY]) {
                        lowY = cellY;
                        result.addAll(this.getAllSubsequences(ringX, cellY));
                    }
                    --cellY;
                }
            }
            if (ringNewYExists) {
                int cellX = rightX;
                while (cellX > ringX) {
                    if (this.equalMatrix[cellX][ringY]) {
                        rightX = cellX;
                        result.addAll(this.getAllSubsequences(cellX, ringY));
                    }
                    --cellX;
                }
            }
            if (ringNewXExists && ringNewYExists && this.equalMatrix[ringX][ringY]) {
                result.addAll(this.getAllSubsequences(ringX, ringY));
                break;
            }
            if (ringNewXExists) {
                if (ringX + 1 <= rightX) {
                    ++ringX;
                } else {
                    ringNewXExists = false;
                }
            }
            if (!ringNewYExists) continue;
            if (ringY + 1 <= lowY) {
                ++ringY;
                continue;
            }
            ringNewYExists = false;
        }
        return result;
    }

    private ArrayList<ArrayList<Pair<TSNodeLabel>>> getAllSubsequences(int x, int y) {
        Cell stored = this.subSequencesMatrix[x][y];
        if (stored == null) {
            this.subSequencesMatrix[x][y] = stored = new Cell(x, y);
            int ringX = x + 1;
            int ringY = y + 1;
            int lowY = this.yMax;
            int rightX = this.xMax;
            boolean ringNewXExists = ringX < this.xLength;
            boolean ringNewYExists = ringY < this.yLength;
            while (ringNewXExists || ringNewYExists) {
                if (ringNewXExists) {
                    int cellY = lowY;
                    while (cellY > ringY) {
                        if (this.equalMatrix[ringX][cellY]) {
                            lowY = cellY;
                            stored.addSubSequences(this.getAllSubsequences(ringX, cellY));
                        }
                        --cellY;
                    }
                }
                if (ringNewYExists) {
                    int cellX = rightX;
                    while (cellX > ringX) {
                        if (this.equalMatrix[cellX][ringY]) {
                            rightX = cellX;
                            stored.addSubSequences(this.getAllSubsequences(cellX, ringY));
                        }
                        --cellX;
                    }
                }
                if (ringNewXExists && ringNewYExists && this.equalMatrix[ringX][ringY]) {
                    stored.addSubSequences(this.getAllSubsequences(ringX, ringY));
                    break;
                }
                if (ringNewXExists) {
                    if (ringX + 1 <= rightX) {
                        ++ringX;
                    } else {
                        ringNewXExists = false;
                    }
                }
                if (!ringNewYExists) continue;
                if (ringY + 1 <= lowY) {
                    ++ringY;
                    continue;
                }
                ringNewYExists = false;
            }
            if (stored.subSequences.isEmpty()) {
                stored.addDefaultSingletonPair();
            }
        }
        return stored.subSequences;
    }

    public static int indexOf(TSNodeLabel c, TSNodeLabel[] a) {
        int i = 0;
        while (i < a.length) {
            if (c == a[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private class Cell {
        ArrayList<ArrayList<Pair<TSNodeLabel>>> subSequences;
        Pair<TSNodeLabel> pair;
        TSNodeLabel cX;
        TSNodeLabel cY;

        public Cell(int x, int y) {
            this.cX = AllOrderedNodeSubSet.this.a1[x];
            this.cY = AllOrderedNodeSubSet.this.a2[y];
            this.pair = new Pair<TSNodeLabel>(AllOrderedNodeSubSet.this.a1[x], AllOrderedNodeSubSet.this.a2[y]);
            this.subSequences = new ArrayList();
        }

        public void addDefaultSingletonPair() {
            ArrayList<Pair<TSNodeLabel>> singleton = new ArrayList<Pair<TSNodeLabel>>(1);
            singleton.add(new Pair<TSNodeLabel>(this.cX, this.cY));
            this.subSequences.add(singleton);
        }

        public void addSubSequences(ArrayList<ArrayList<Pair<TSNodeLabel>>> otherSubSequences) {
            for (ArrayList<Pair<TSNodeLabel>> otherListPair : otherSubSequences) {
                ArrayList<Pair<TSNodeLabel>> newListPair = new ArrayList<Pair<TSNodeLabel>>(otherListPair.size() + 1);
                newListPair.add(this.pair);
                newListPair.addAll(otherListPair);
                this.subSequences.add(newListPair);
            }
        }

        public String toString() {
            String result = "";
            ListIterator<ArrayList<Pair<TSNodeLabel>>> iter1 = this.subSequences.listIterator();
            while (iter1.hasNext()) {
                ArrayList<Pair<TSNodeLabel>> s = iter1.next();
                result = String.valueOf(result) + "(";
                ListIterator<Pair<TSNodeLabel>> iter2 = s.listIterator();
                while (iter2.hasNext()) {
                    Pair<TSNodeLabel> p = iter2.next();
                    TSNodeLabel c1 = p.getFirst();
                    TSNodeLabel c2 = p.getSecond();
                    int i1 = AllOrderedNodeSubSet.indexOf(c1, AllOrderedNodeSubSet.this.a1);
                    int i2 = AllOrderedNodeSubSet.indexOf(c2, AllOrderedNodeSubSet.this.a2);
                    result = String.valueOf(result) + "(" + c1 + i1 + "," + c2 + i2 + ")";
                    if (!iter2.hasNext()) continue;
                    result = String.valueOf(result) + ", ";
                }
                result = String.valueOf(result) + ")";
                if (!iter1.hasNext()) continue;
                result = String.valueOf(result) + ", ";
            }
            return result;
        }
    }
}

