/*
 * Decompiled with CFR 0.152.
 */
package wordModel;

import java.util.ArrayList;
import java.util.Hashtable;
import symbols.SymbolString;
import tsg.TSNodeLabel;
import util.Utility;

public class WordPosFreq {
    Hashtable<SymbolString, int[]> freqTable = new Hashtable();

    public WordPosFreq(ArrayList<TSNodeLabel> corpus) {
        for (TSNodeLabel t : corpus) {
            ArrayList<TSNodeLabel> lex = t.collectLexicalItems();
            for (TSNodeLabel l : lex) {
                String word = l.label();
                String pos = l.parent.label();
                SymbolString wordPos = new SymbolString(String.valueOf(word) + "_" + pos);
                Utility.increaseInTableInt(this.freqTable, wordPos);
            }
        }
    }

    public int getFreq(TSNodeLabel l) {
        if (!l.isLexical) {
            return 0;
        }
        String word = l.label();
        String pos = l.parent.label();
        return this.getFreq(word, pos);
    }

    public int getFreq(String word, String pos) {
        SymbolString wordPos = new SymbolString(String.valueOf(word) + "_" + pos);
        int[] freq = this.freqTable.get(wordPos);
        if (freq == null) {
            return 0;
        }
        return freq[0];
    }
}

