import os
import pandas as pd
from scipy.stats import ttest_rel

root = os.path.join(".", "Results_OpenLID")

for file in os.listdir(root):
    if file.endswith(".csv") and "lang_specific" in file:

        meta = file.split(".")
        region = meta[2]
        model = meta[3]

        if model == "full_results":

            df = pd.read_csv(os.path.join(root, file), index_col = 0)
            #print(df)

            prec = ttest_rel(df.loc[:,"Geo_Precision"].values, df.loc[:,"Baseline_Precision"].values, axis=0, alternative="greater")[1]
            rec = ttest_rel(df.loc[:,"Geo_Recall"].values, df.loc[:,"Baseline_Recall"].values, axis=0, alternative="greater")[1]
            f = ttest_rel(df.loc[:,"Geo_FScore"].values, df.loc[:,"Baseline_FScore"].values, axis=0, alternative="greater")[1]

            # if prec < 0.05:
                # prec = "YES"
            # else:
                # prec = "NO"

            # if rec < 0.05:
                # rec = "YES"
            # else:
                # rec = "NO"

            # if f < 0.05:
                # f = "YES"
            # else:
                # f = "NO"

            print(region, f)
