# you need execute retrieving externally to improve the efficiency.
from config import Config
from tasks.query_expansion.query_expansion_0724 import QueryExpansion
from tasks.query_rewriting.query_rewriting_0724 import QueryRewrite
from pipeline_base import *


def run_pipeline():
    config = Config()
    if not config.add_retriever:
        run_llm(config.llm_reader)

    if config.add_query_augmenter:
        augment_query(config.dataset)

    add_retrieve_evidence(config.knowledge_corpus, config.retriever)

    if config.add_majority_vote:
        run_llm(config.llm_reader, config.topk)
    else:
        run_llm(config.llm_reader, 1)
    statistic_performance(config.output_file)
















