prompt_len=20
prompt_config='configs/config_prompt_p20.json'
model='t5-base'
output_root='t5_base'

for seed in {42..44}
do
    # BiKT
    python -m torch.distributed.launch --nproc_per_node=8 --use_env train_t5_multitask.py \
        --use_prompt \
        --config ./configs/Source/multitask.yaml \
        --prompt_config $prompt_config \
        --output_dir output/$output_root/p$prompt_len/seed$seed/multitask/bikt \
        --multitask_train_prompt \
        --fix_word_embeddings \
        --text_encoder $model \
        --seed $seed \
        --batch_size 16 \
        --dataset_root /data/Datasets/public_data/text2text

    # BiKT without prompt for feedback
    python -m torch.distributed.launch --nproc_per_node=8 --use_env train_t5_multitask.py \
        --config ./configs/Source/multitask.yaml \
        --output_dir output/$output_root/p$prompt_len/seed$seed/multitask/finetuning \
        --text_encoder $model \
        --seed $seed \
        --batch_size 16 \
         --dataset_root /data/Datasets/public_data/text2text

    # multitask prompt tuning
    python -m torch.distributed.launch --nproc_per_node=8 --use_env train_t5_multitask.py \
        --use_prompt \
        --only_prompt \
        --prompt_config $prompt_config \
        --config ./configs/Source/multitask_prompt.yaml \
        --output_dir output/$output_root/p$prompt_len/seed$seed/multitask/prompt_tuning \
        --text_encoder $model \
        --seed $seed \
        --batch_size 16 \
        --dataset_root /data/Datasets/public_data/text2text
done