/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.concurrent.MulticoreWrapper;
import edu.stanford.nlp.util.concurrent.ThreadsafeProcessor;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class POSTaggerAnnotator
implements Annotator {
    private final MaxentTagger pos;
    private final int maxSentenceLength;
    private final int nThreads;
    private final boolean reuseTags;

    public POSTaggerAnnotator() {
        this(false);
    }

    public POSTaggerAnnotator(boolean verbose) {
        this(System.getProperty("pos.model", "edu/stanford/nlp/models/pos-tagger/english-left3words/english-left3words-distsim.tagger"), verbose);
    }

    public POSTaggerAnnotator(String posLoc, boolean verbose) {
        this(posLoc, verbose, Integer.MAX_VALUE, 1);
    }

    public POSTaggerAnnotator(String posLoc, boolean verbose, int maxSentenceLength, int numThreads) {
        this(POSTaggerAnnotator.loadModel(posLoc, verbose), maxSentenceLength, numThreads);
    }

    public POSTaggerAnnotator(MaxentTagger model) {
        this(model, Integer.MAX_VALUE, 1);
    }

    public POSTaggerAnnotator(MaxentTagger model, int maxSentenceLength, int numThreads) {
        this.pos = model;
        this.maxSentenceLength = maxSentenceLength;
        this.nThreads = numThreads;
        this.reuseTags = false;
    }

    public POSTaggerAnnotator(String annotatorName, Properties props) {
        String posLoc = props.getProperty(annotatorName + ".model");
        if (posLoc == null) {
            posLoc = "edu/stanford/nlp/models/pos-tagger/english-left3words/english-left3words-distsim.tagger";
        }
        boolean verbose = PropertiesUtils.getBool(props, annotatorName + ".verbose", false);
        this.pos = POSTaggerAnnotator.loadModel(posLoc, verbose);
        this.maxSentenceLength = PropertiesUtils.getInt(props, annotatorName + ".maxlen", Integer.MAX_VALUE);
        this.nThreads = PropertiesUtils.getInt(props, annotatorName + ".nthreads", PropertiesUtils.getInt(props, "nthreads", 1));
        this.reuseTags = PropertiesUtils.getBool(props, annotatorName + ".reuseTags", false);
    }

    public static String signature(Properties props) {
        return "pos.maxlen:" + props.getProperty("pos.maxlen", "") + "pos.verbose:" + PropertiesUtils.getBool(props, "pos.verbose") + "pos.reuseTags:" + PropertiesUtils.getBool(props, "pos.reuseTags") + "pos.model:" + props.getProperty("pos.model", "edu/stanford/nlp/models/pos-tagger/english-left3words/english-left3words-distsim.tagger") + "pos.nthreads:" + props.getProperty("pos.nthreads", props.getProperty("nthreads", ""));
    }

    private static MaxentTagger loadModel(String loc, boolean verbose) {
        Timing timer = null;
        if (verbose) {
            timer = new Timing();
            timer.doing("Loading POS Model [" + loc + ']');
        }
        MaxentTagger tagger = new MaxentTagger(loc);
        if (verbose) {
            timer.done();
        }
        return tagger;
    }

    @Override
    public void annotate(Annotation annotation) {
        if (annotation.has(CoreAnnotations.SentencesAnnotation.class)) {
            if (this.nThreads == 1) {
                for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                    this.doOneSentence(sentence);
                }
            } else {
                MulticoreWrapper<CoreMap, CoreMap> wrapper = new MulticoreWrapper<CoreMap, CoreMap>(this.nThreads, new POSTaggerProcessor());
                for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                    wrapper.put(sentence);
                    while (wrapper.peek()) {
                        wrapper.poll();
                    }
                }
                wrapper.join();
                while (wrapper.peek()) {
                    wrapper.poll();
                }
            }
        } else {
            throw new RuntimeException("unable to find words/tokens in: " + annotation);
        }
    }

    private CoreMap doOneSentence(CoreMap sentence) {
        List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        List<TaggedWord> tagged = null;
        if (tokens.size() <= this.maxSentenceLength) {
            try {
                tagged = this.pos.tagSentence(tokens, this.reuseTags);
            }
            catch (OutOfMemoryError e) {
                System.err.println("WARNING: Tagging of sentence ran out of memory. Will ignore and continue: " + Sentence.listToString(tokens));
            }
        }
        if (tagged != null) {
            int sz = tokens.size();
            for (int i = 0; i < sz; ++i) {
                ((CoreLabel)tokens.get(i)).set(CoreAnnotations.PartOfSpeechAnnotation.class, tagged.get(i).tag());
            }
        } else {
            int sz = tokens.size();
            for (int i = 0; i < sz; ++i) {
                ((CoreLabel)tokens.get(i)).set(CoreAnnotations.PartOfSpeechAnnotation.class, "X");
            }
        }
        return sentence;
    }

    @Override
    public Set<Annotator.Requirement> requires() {
        return TOKENIZE_AND_SSPLIT;
    }

    @Override
    public Set<Annotator.Requirement> requirementsSatisfied() {
        return Collections.singleton(POS_REQUIREMENT);
    }

    private class POSTaggerProcessor
    implements ThreadsafeProcessor<CoreMap, CoreMap> {
        private POSTaggerProcessor() {
        }

        @Override
        public CoreMap process(CoreMap sentence) {
            return POSTaggerAnnotator.this.doOneSentence(sentence);
        }

        @Override
        public ThreadsafeProcessor<CoreMap, CoreMap> newInstance() {
            return this;
        }
    }
}

