/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.surface;

import edu.stanford.nlp.patterns.surface.ConstantsAndVariables;
import edu.stanford.nlp.patterns.surface.Data;
import edu.stanford.nlp.patterns.surface.GetPatternsFromDataMultiClass;
import edu.stanford.nlp.patterns.surface.PhraseScorer;
import edu.stanford.nlp.patterns.surface.SurfacePattern;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ScorePhrasesAverageFeatures
extends PhraseScorer {
    private TwoDimensionalCounter<String, ConstantsAndVariables.ScorePhraseMeasures> phraseScoresNormalized = new TwoDimensionalCounter();

    public ScorePhrasesAverageFeatures(ConstantsAndVariables constvar) {
        super(constvar);
    }

    @Override
    public Counter<String> scorePhrases(String label, TwoDimensionalCounter<String, SurfacePattern> terms, TwoDimensionalCounter<String, SurfacePattern> wordsPatExtracted, Counter<SurfacePattern> allSelectedPatterns, Set<String> alreadyIdentifiedWords, boolean forLearningPatterns) {
        HashMap scores = new HashMap();
        if (Data.domainNGramsFile != null) {
            Data.loadDomainNGrams();
        }
        ClassicCounter<String> tfidfScores = new ClassicCounter<String>();
        if (this.constVars.usePhraseEvalPatWtByFreq) {
            for (Map.Entry<String, ClassicCounter<SurfacePattern>> en : terms.entrySet()) {
                double score = this.getPatTFIDFScore(en.getKey(), (Counter<SurfacePattern>)en.getValue(), allSelectedPatterns);
                tfidfScores.setCount(en.getKey(), score);
            }
            Redwood.log("extremePatDebug", "BEFORE IDF " + Counters.toSortedString(tfidfScores, 100, "%1$s:%2$f", "\t"));
            Counters.divideInPlace(tfidfScores, Data.processedDataFreq);
        }
        Counter<String> externalFeatWtsNormalized = new ClassicCounter<String>();
        Counter<String> domainNgramNormScores = new ClassicCounter<String>();
        Counter<String> googleNgramNormScores = new ClassicCounter<String>();
        ClassicCounter<String> editDistanceOtherBinaryScores = new ClassicCounter<String>();
        ClassicCounter<String> editDistanceSameBinaryScores = new ClassicCounter<String>();
        for (String g : terms.firstKeySet()) {
            if (this.constVars.usePhraseEvalEditDistOther) {
                editDistanceOtherBinaryScores.setCount(g, 1.0 - this.constVars.getEditDistanceScoresOtherClassThreshold(g));
            }
            if (this.constVars.usePhraseEvalEditDistSame) {
                editDistanceSameBinaryScores.setCount(g, this.constVars.getEditDistanceScoresThisClassThreshold(label, g));
            }
            if (this.constVars.usePhraseEvalDomainNgram) {
                if (Data.domainNGramRawFreq.containsKey(g)) {
                    assert (Data.rawFreq.containsKey(g));
                    domainNgramNormScores.setCount(g, this.getDomainNgramScore(g));
                } else {
                    System.err.println("why is " + g + " not present in domainNgram");
                }
            }
            if (this.constVars.usePhraseEvalGoogleNgram && Data.googleNGram.containsKey(g)) {
                assert (Data.rawFreq.containsKey(g));
                googleNgramNormScores.setCount(g, (1.0 + Data.rawFreq.getCount(g) * Math.sqrt(Data.ratioGoogleNgramFreqWithDataFreq)) / Data.googleNGram.getCount(g));
            }
            if (!this.constVars.usePhraseEvalWordClass) continue;
            Integer num = this.constVars.getWordClassClusters().get(g);
            if (num != null && this.constVars.distSimWeights.get(label).containsKey(num)) {
                externalFeatWtsNormalized.setCount(g, this.constVars.distSimWeights.get(label).getCount(num));
                continue;
            }
            externalFeatWtsNormalized.setCount(g, this.OOVExternalFeatWt);
        }
        Counter<String> normTFIDFScores = GetPatternsFromDataMultiClass.normalizeSoftMaxMinMaxScores(tfidfScores, true, true, false);
        Counter<String> dictOdddsScores = null;
        if (this.constVars.usePhraseEvalSemanticOdds) {
            assert (this.constVars.dictOddsWeights != null) : "usePhraseEvalSemanticOdds is true but dictOddsWeights is null for the label " + label;
            dictOdddsScores = GetPatternsFromDataMultiClass.normalizeSoftMaxMinMaxScores(this.constVars.dictOddsWeights.get(label), true, true, false);
        }
        domainNgramNormScores = GetPatternsFromDataMultiClass.normalizeSoftMaxMinMaxScores(domainNgramNormScores, true, true, false);
        googleNgramNormScores = GetPatternsFromDataMultiClass.normalizeSoftMaxMinMaxScores(googleNgramNormScores, true, true, false);
        externalFeatWtsNormalized = GetPatternsFromDataMultiClass.normalizeSoftMaxMinMaxScores(externalFeatWtsNormalized, true, true, false);
        for (String word : terms.firstKeySet()) {
            if (alreadyIdentifiedWords.contains(word)) continue;
            ClassicCounter<ConstantsAndVariables.ScorePhraseMeasures> scoreslist = new ClassicCounter<ConstantsAndVariables.ScorePhraseMeasures>();
            assert (normTFIDFScores.containsKey(word)) : "NormTFIDF score does not contain" + word;
            double tfscore = normTFIDFScores.getCount(word);
            scoreslist.setCount(ConstantsAndVariables.ScorePhraseMeasures.PATWTBYFREQ, tfscore);
            if (this.constVars.usePhraseEvalSemanticOdds) {
                double dscore = dictOdddsScores.containsKey(word) ? dictOdddsScores.getCount(word) : this.getPhraseWeightFromWords(dictOdddsScores, word, this.OOVdictOdds);
                scoreslist.setCount(ConstantsAndVariables.ScorePhraseMeasures.SEMANTICODDS, dscore);
            }
            if (this.constVars.usePhraseEvalDomainNgram) {
                double domainscore = domainNgramNormScores.containsKey(word) ? domainNgramNormScores.getCount(word) : this.getPhraseWeightFromWords(domainNgramNormScores, word, this.OOVDomainNgramScore);
                scoreslist.setCount(ConstantsAndVariables.ScorePhraseMeasures.DOMAINNGRAM, domainscore);
            }
            if (this.constVars.usePhraseEvalGoogleNgram) {
                double googlescore = googleNgramNormScores.containsKey(word) ? googleNgramNormScores.getCount(word) : this.getPhraseWeightFromWords(googleNgramNormScores, word, this.OOVGoogleNgramScore);
                scoreslist.setCount(ConstantsAndVariables.ScorePhraseMeasures.GOOGLENGRAM, googlescore);
            }
            if (this.constVars.usePhraseEvalWordClass) {
                double externalFeatureWt = externalFeatWtsNormalized.containsKey(word) ? externalFeatWtsNormalized.getCount(word) : this.getPhraseWeightFromWords(externalFeatWtsNormalized, word, this.OOVExternalFeatWt);
                scoreslist.setCount(ConstantsAndVariables.ScorePhraseMeasures.DISTSIM, externalFeatureWt);
            }
            if (this.constVars.usePhraseEvalEditDistOther) {
                assert (editDistanceOtherBinaryScores.containsKey(word)) : "How come no edit distance info?";
                double editD = editDistanceOtherBinaryScores.getCount(word);
                scoreslist.setCount(ConstantsAndVariables.ScorePhraseMeasures.EDITDISTOTHER, editD);
            }
            if (this.constVars.usePhraseEvalEditDistSame) {
                double editDSame = editDistanceSameBinaryScores.getCount(word);
                scoreslist.setCount(ConstantsAndVariables.ScorePhraseMeasures.EDITDISTSAME, editDSame);
            }
            if (this.constVars.usePhraseEvalWordShape) {
                scoreslist.setCount(ConstantsAndVariables.ScorePhraseMeasures.WORDSHAPE, this.getWordShapeScore(word, label));
            }
            scores.put(word, scoreslist);
            this.phraseScoresNormalized.setCounter(word, scoreslist);
        }
        ClassicCounter<String> phraseScores = new ClassicCounter<String>();
        for (Map.Entry wEn : scores.entrySet()) {
            double avgScore = Counters.mean((Counter)wEn.getValue());
            phraseScores.setCount((String)wEn.getKey(), avgScore);
        }
        return phraseScores;
    }

    @Override
    public Counter<String> scorePhrases(String label, Set<String> terms, boolean forLearningPatterns) throws IOException {
        throw new RuntimeException("not implemented");
    }
}

