from src.evaluation.alpaca_eval_gen import (
    gen_judgment, AlpacaEvalJudgeArgs
)
from src.trainers.configs import H4ArgumentParser
import os


def main(args: AlpacaEvalJudgeArgs):
    gen_result_file = os.path.join(args.output_path, 'model_outputs.json')
    judge_result_file = os.path.join(args.output_path, args.annotators_config, 'leaderboard.csv')
    if not os.path.exists(gen_result_file):
        raise FileNotFoundError(f"Model outputs not found at {gen_result_file}")
    if not os.path.exists(judge_result_file):
        raise FileNotFoundError(f"Judgment results not found at {judge_result_file}")

    args.leaderboard_mode_to_print = None  # filter none, display all
    gen_judgment(args)
    return


if __name__ == '__main__':
    parser = H4ArgumentParser((AlpacaEvalJudgeArgs,))
    judge_args = parser.parse()
    
    main(judge_args)