"""
Generates a string with numbered email tags and placeholders for content.

Parameters:
count (int): Number of email tags to generate.

Returns:
str: Formatted string with email tags and placeholders.

Example:
>>> create_email_format_prompt(2)
'<email_1>\n{}\n</email_1>\n<email_2>\n{}\n</email_2>\n'
"""
def create_email_format_prompt(count):
    out = "<ground_truth>\n{}\n</ground_truth>\n"
    for i in range(1, count + 1):
        out += f"<email_{i}>\n{{}}\n</email_{i}>\n"
    return out