theory question_67_10

imports Main

consts
  LightBulb :: "entity ⇒ bool"
  TurnedOn :: "event ⇒ bool"
  Energy :: "entity ⇒ bool"
  Converts :: "entity ⇒ event ⇒ entity ⇒ entity ⇒ bool"
  ElectricalEnergy :: "entity ⇒ bool"
  LightEnergy :: "entity ⇒ bool"
  HeatEnergy :: "entity ⇒ bool"

(* Explanation 1: A light bulb converts energy when turned on, specifically from electrical energy to light and heat energy. *)
axiomatization where
  explanation_1: "∀x e. LightBulb x ∧ TurnedOn e ⟶ (∃y z. Energy y ∧ Converts x e y z ∧ ElectricalEnergy y ∧ LightEnergy z ∧ HeatEnergy z)"

theorem hypothesis:
  (* Premise: when a light bulb is turned on, energy changes from one form to another. *)
  assumes asm: "LightBulb x ∧ TurnedOn e ∧ ChangesFromOneFormToAnother x e"
  (* Hypothesis: The change best described is from electrical energy to light energy. *)
  shows "ChangesFromOneFormToAnother x e ∧  ElectricalEnergy  old_entity x  ∧ LightEnergy  new_entity x'  "
proof -
  from asm have "LightBulb x" and also "TurnedOn e" by simp
  then have "ChangesFromOneFormToAnother x e" using asm by simp
  then obtain old_entity new_entity where old_new: "Converts x e old_entity new_entity" using asm by blast
  then have "Energy old_entity" and also "Energy new_entity" using old_new by simp
  then have "ElectricalEnergy old_entity" and also "LightEnergy new_entity" using explanation_1 by blast
  then show ?thesis using old_new asm by blast
qed
end
