theory question_66_3
imports Main

begin

typedecl entity

consts
  Sun :: "entity ⇒ bool"
  Star :: "entity ⇒ bool"
  CelestialBody :: "entity ⇒ bool"
  Planet :: "entity ⇒ bool"
  HotterThan :: "entity ⇒ entity ⇒ bool"
  Earth :: "entity"
  Mars :: "entity"
  Moon :: "entity"

(* Explanation 1: The Sun is a star, and stars are celestial bodies that are generally hotter than planets. *)
axiomatization where
  explanation_1: "∀x. Sun x ⟶ Star x"
and
  explanation_1_2: "∀x y. Star x ∧ CelestialBody y ⟶ HotterThan x y"

(* Explanation 2: The Sun is specifically hotter than the Earth, Mars, and the Moon. *)
axiomatization where
  explanation_2: "∀x. Sun x ⟶ HotterThan x Earth ∧ HotterThan x Mars ∧ HotterThan x Moon"

theorem hypothesis:
  assumes asm: "Sun x"
  (* Hypothesis: The Sun is the hottest among the Earth, Mars, and the Moon. *)
  shows "HotterThan x Earth ∧ HotterThan x Mars ∧ HotterThan x Moon"
proof -
  from asm have "Sun x" by simp
  then have "HotterThan x Earth ∧ HotterThan x Mars ∧ HotterThan x Moon" using explanation_2 by blast
  then show ?thesis by simp
qed

end
