theory question_64_4

imports Main

begin

typedecl entity
typedecl event

consts
  Field :: "entity ⇒ bool"
  Environment :: "entity ⇒ bool"
  Animal :: "entity ⇒ bool"
  Mouse :: "entity ⇒ bool"
  FoodSupply :: "entity ⇒ event ⇒ bool"
  Population :: "entity ⇒ entity ⇒ event ⇒ bool"
  Decrease :: "event ⇒ bool"

theorem hypothesis:
  (* Premise: if its food supply in a field decreases *)
  assumes asm: "Field f  ∧ FoodSupply f  e  ∧ Decrease e "
  (* Hypothesis: The mouse population in that field will probably decrease *)
  shows "∃f e. Field f  ∧ MousePopulation f  e  ∧ Decrease e "
proof -
  from asm have "Field f ∧ FoodSupply f e ∧ Environment f" by (rule explanation_2)
  then have "Animals f" using explanation_1 by blast
  then have "Mouse `f`" using explanation_3 by blast
  have "Decrease e ∧ Population `Mouse` f e ∧ Decrease e" by (rule explanation_5)
  then show "∃f e. Field f ∧ MousePopulation f e ∧ Decrease e" using asm by blast
qed

end
