theory question_39_2

imports Main

begin

typedecl entity
typedecl event

consts
  Wear :: "event ⇒ entity ⇒ bool"
  SafetyGoggles :: "entity ⇒ bool"
  Eye :: "entity ⇒ bool"
  Protect :: "event ⇒ entity ⇒ bool"

(* Explanation Sentence 5: Wearing safety goggles protects the eyes. *)
axiomatization where
  explanation_5: "∀e x y. Wear e x ∧ SafetyGoggles x ⟶ Protect e y ∧ Eye y"

theorem hypothesis:
  assumes asm: "Wear e x ∧ SafetyGoggles x"
  (* Hypothesis: There is a wearing event where safety goggles are worn. *)
  shows "∃e y. Protect e y ∧ Eye y"
proof -
  from asm have "Wear e x ∧ SafetyGoggles x" by simp
  then have "Protect e y ∧ Eye y" for y using explanation_5 by blast
  then have "∃y. Protect e y ∧ Eye y" by auto
  then show "?thesis" by blast
qed

end
