theory question_81_3

imports Main

begin

typedecl entity
typedecl event

consts
  ExternalMigration :: "entity ⇒ bool"
  Entity :: "entity ⇒ bool"
  PopulationSize :: "entity ⇒ bool"
  Cause :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  SuddenReduction :: "event ⇒ bool"
  BottleneckEffect :: "event ⇒ bool"
  Occur :: "event ⇒ bool"
  Result :: "event ⇒ event ⇒ bool"

(* Explanation 1: External migration can cause a sudden reduction in the population size of a specific entity. *)
axiomatization where
  explanation_1: "∀x y e1 e2. ExternalMigration x ∧ Entity y ∧ PopulationSize y ⟶ (∃e1. Cause e1 ∧ Agent e1 x ∧ Patient e1 y) ∧ (∃e2. SuddenReduction e2 ∧ Agent e2 e1 ∧ Patient e2 y)"

(* Explanation 2: A sudden reduction in the population size of a specific entity is a necessary condition for the bottleneck effect to occur in that entity, and the bottleneck effect is an event that occurs as a result. *)
axiomatization where
  explanation_2: "∀x y e1 e2. Entity x ∧ PopulationSize y ∧ SuddenReduction e1 ∧ Agent e1 y ∧ Patient e1 x ⟶ (∃e2. BottleneckEffect e2 ∧ Occur e2 ∧ Agent e2 x ∧ Result e2 e1)"

theorem hypothesis:
  assumes asm: "ExternalMigration x"
  (* Hypothesis: Bottleneck effect can occur with external migration. *)
  shows "∃e. BottleneckEffect e ∧ Occur e ∧ Agent e x"
proof -
  from asm have "ExternalMigration x" by simp
  then obtain y e1 e2 where e1: "Cause e1 ∧ Agent e1 x ∧ Patient e1 y" and e2: "SuddenReduction e2 ∧ Agent e2 e1 ∧ Patient e2 y" using explanation_1 by blast
  then have "Entity y" "PopulationSize y" by (auto simp: e1 e2)
  then obtain e3 where e3: "BottleneckEffect e3 ∧ Occur e3 ∧ Agent e3 x ∧ Result e3 e2" using explanation_2 by blast
  show ?thesis using e3 by blast
qed

end
