theory question_81_1
imports Main

begin
typedecl entity
typedecl event

consts
  Bike :: "entity ⇒ bool"
  Bicycle :: "entity ⇒ bool"
  Person :: "entity ⇒ bool"
  Helmet :: "entity ⇒ bool"
  Ground :: "entity"
  Skyline :: "entity"
  Lake :: "entity"
  Wears :: "event ⇒ entity ⇒ entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Jumps :: "event ⇒ bool"
  SoaringOver :: "event ⇒ entity ⇒ bool"
  Outside :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  Has :: "entity ⇒ entity ⇒ bool"
  InFrontOf :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Bike is a short word for bicycle. *)
axiomatization where
  explanation_1: "∀x. Bike x ⟷ Bicycle x"

(* Explanation 2: A person is outside if they are soaring over the ground. *)
axiomatization where
  explanation_2: "∀x. Person x ∧ SoaringOver x Ground ⟶ Outside x"

(* Explanation 3: A person has a bike if they are on a bicycle. *)
axiomatization where
  explanation_3: "∀x y. Person x ∧ Bicycle y ∧ On x y ⟶ Has x y"

theorem hypothesis:
  (* Premise: A person on a bicycle wears a helmet and jumps, soaring over the ground in front of a skyline and lake. *)
  assumes asm: "Person x ∧ Bicycle y ∧ Helmet z ∧ Wears e1 x z ∧ Agent e1 x ∧ Jumps e2 ∧ Agent e2 x ∧ SoaringOver e3 x ∧ Agent e3 x ∧ Patient e3 Ground ∧ InFrontOf x Skyline ∧ InFrontOf x Lake ∧ On x y"
  (* Hypothesis: A person is outside with a bike. *)
  shows "∃x y. Person x ∧ Bike y ∧ Outside x ∧ Has x y"
proof -
  {
    assume "Person x ∧ Bicycle y ∧ Helmet z ∧ Wears e1 x z ∧ Agent e1 x ∧ Jumps e2 ∧ Agent e2 x ∧ SoaringOver e3 x ∧ Agent e3 x ∧ Patient e3 Ground ∧ InFrontOf x Skyline ∧ InFrontOf x Lake ∧ On x y"
    then have "Person x" by blast
    moreover have "Bicycle y" by blast
    moreover have "SoaringOver x Ground" using that by blast
    ultimately have "Person x ∧ Outside x" using explanation_2 by blast
    moreover have "Has x y" using that explanation_3 by blast
    ultimately have "Person x ∧ Bike y ∧ Outside x ∧ Has x y" using explanation_1 by blast
  }
  then show ?thesis by blast
qed

end
