theory question_30_6

imports Main

begin

typedecl entity
typedecl event

consts
 Hot :: "entity ⇒ bool"
 Boil :: "event ⇒ bool"
 Temperature :: "entity ⇒ num"
 Pressure :: "entity ⇒ num"
 GasLaw :: "event ⇒ bool"
 IdealGasLaw :: "event ⇒ bool"
 MolarMass :: "entity ⇒ num"
 Density :: "entity ⇒ num"
 SpeedOfSound :: "entity ⇒ num"

(* Explanation 1: Water boils at 100 degrees Celsius. *)
axiomatization where
 explanation_1: "∀x. Temperature x ≤ 100 ∧ Boil x"

(* Explanation 2: The atmospheric pressure is 1013 mbar. *)
axiomatization where
 explanation_2: "Pressure 1013"

theorem hypothesis:
 assumes asm: "Hot x ∧ Temperature y ∧ Pressure z"
 (* Hypothesis: If it is hot, then water boils. *)
 shows "∃e. Boil e ∧ Agent e x ∧ Patient e y ∧ Change e z"
proof -
 from asm have "Hot x ∧ Temperature y ∧ Pressure z" by simp
 then obtain e1 where e1: "Boil e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Change e1 z" using explanation_1 by blast
 then have "Temperature y ≤ 100" using explanation_2 by simp
 then show ?thesis using e1 by auto
qed

end
