theory question_21_0

imports Main

begin

typedecl entity
typedecl event

consts
  Birds :: "entity ⇒ bool"
  EndothermicTetrapodVertebrate :: "entity ⇒ bool"
  ClassAves :: "entity ⇒ bool"

(* Explanation 1: Birds are endothermic tetrapod vertebrates. *)
axiomatization where
  explanation_1: "∀x. Birds x ∧ EndothermicTetrapodVertebrate x"

(* Explanation 2: Class Aves is for the birds, literally. *)
axiomatization where
  explanation_2: "∀x. ClassAves x ∧ Birds x"  

theorem hypothesis:
  assumes asm: "EndothermicTetrapodVertebrate x"
  (* Hypothesis: An endothermic tetrapod vertebrate would be animals in the class aves. *)
  shows "∃x. ClassAves x ∧ Birds x"
proof -
  from asm have "EndothermicTetrapodVertebrate x" by simp
  then obtain e1 where e1: "Birds x ∧ EndothermicTetrapodVertebrate x" using explanation_1 by blast
  then have "ClassAves x" using explanation_2 by blast
  have conclusion: "ClassAves x ∧ Birds x" using e1 by simp
  show ?thesis using asm conclusion by blast
qed

end
