theory question_82_7

imports Main

begin

typedecl entity
typedecl event
consts
  Woman :: "entity ⇒ bool"
  Standing :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  RedHat :: "entity ⇒ bool"
  Waiting :: "event ⇒ bool"
  InLine :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A woman stands in a line. *)
axiomatization where
  explanation_1: "∃x e. Woman x ∧ Standing e ∧ Agent e x"

theorem hypothesis:
  (* Premise: A woman in a red hat waiting in line. *)
  assumes asm: "Woman x ∧ RedHat y ∧ Waiting e ∧ Agent e x ∧ InLine e y"
  (* Hypothesis: A woman stands in a line. *)
  shows "∃x e. Woman x ∧ Standing e ∧ Agent e x"
proof -
  from asm have "Woman x" by blast
  from this have "Standing e" using explanation_1 by blast
  show ?thesis using `Woman x` `Standing e` by blast
qed

end
