theory question_65_4

imports Main

begin

typedecl entity
typedecl event

consts
  Electricity :: "entity ⇒ bool"
  LightBulb :: "entity ⇒ bool"
  Flows :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  TurnOn :: "event ⇒ bool"
  ComesOn :: "event ⇒ bool"
  Switch :: "entity ⇒ bool"
  SimpleSeriesCircuit :: "entity ⇒ bool"
  Closed :: "event ⇒ bool"
  StartsFlowing :: "event ⇒ bool"

(* Explanation 1: When electricity flows to a light bulb, the light bulb will turn on; come on. *)
axiomatization where
  explanation_1: "∀x y e1 e2 e3. Electricity x ∧ LightBulb y ∧ Flows e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ (TurnOn e2 ∧ Agent e2 y) ∨ (ComesOn e3 ∧ Agent e3 y)"

(* Explanation 2: When a switch in a simple series circuit is closed, electricity starts flowing. The electricity flows to the light bulb in the circuit. *)
axiomatization where
  explanation_2: "∀x y z e1 e2 e3. Switch x ∧ SimpleSeriesCircuit y ∧ Electricity z ∧ Closed e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ (StartsFlowing e2 ∧ Agent e2 z) ∧ (Flows e3 ∧ Agent e3 z ∧ Patient e3 y)"

theorem hypothesis:
  (* Premise: when the switch in a simple series circuit is closed *)
  assumes asm: "Switch x ∧ SimpleSeriesCircuit y ∧ Closed e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: When electricity is flowing to the light bulb, the light comes on. *)
  shows "∃x y e. Electricity x ∧ LightBulb y ∧ Flows e ∧ Agent e x ∧ Patient e y ∧ ComesOn e ∧ Agent e y"
proof -
  from asm obtain e2 e3 where e2e3: "(StartsFlowing e2 ∧ Agent e2 x) ∧ (Flows e3 ∧ Agent e3 x ∧ Patient e3 y)" using explanation_2 by blast
  then have "Electricity x ∧ LightBulb y ∧ Flows e3 ∧ Agent e3 x ∧ Patient e3 y" using e2e3 by simp
  then obtain e where e: "ComesOn e ∧ Agent e y" using explanation_1 by blast
  show ?thesis using asm e `Electricity x` `LightBulb y` `Flows e3` `Agent e3 x` `Patient e3 y` by blast
qed

end
