theory question_13_10
imports Main
begin

typedecl entity
typedecl event

consts
  Pan :: "entity ⇒ bool"
  Water :: "entity ⇒ bool"
  State :: "entity ⇒ bool"
  Heating :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  ChangeState :: "event ⇒ bool"
  Gone :: "event ⇒ bool"
  Liquid :: "entity ⇒ bool"
  DifferentState :: "entity ⇒ bool"
  Changes :: "event ⇒ bool"
  Becomes :: "event ⇒ bool"
  StateOfMatter :: "entity ⇒ bool"
  Gas :: "entity ⇒ bool"

(* Explanation 1: When a pan of water is heated, it changes state. *)
axiomatization where
  explanation_1: "∀x y z e1 e2. Pan x ∧ Water y ∧ State z ∧ Heating e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ ChangeState e2 ∧ Agent e2 y ∧ Patient e2 z"

(* Explanation 2: Water is a kind of liquid. *)
axiomatization where
  explanation_2: "∀x. Water x ⟶ Liquid x"

(* Explanation 3: Liquid is a kind of state. *)
axiomatization where
  explanation_3: "∀x. Liquid x ⟶ State x"

(* Explanation 4: When a state changes, it becomes a different state. *)
axiomatization where
  explanation_4: "∀x y e1 e2. State x ∧ DifferentState y ∧ Changes e1 ∧ Agent e1 x ⟶ Becomes e2 ∧ Agent e2 x ∧ Patient e2 y"

(* Explanation 5: A state is a kind of state of matter. *)
axiomatization where
  explanation_5: "∀x. State x ⟶ StateOfMatter x"

(* Explanation 6: Gas is a kind of state of matter. *)
axiomatization where
  explanation_6: "∀x. Gas x ⟶ StateOfMatter x"

theorem hypothesis:
  assumes asm: "Pan x ∧ Water y ∧ State z ∧ Heating e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Gone e2 ∧ Agent e2 y"
  (* Hypothesis: Heating a pan of water until the water is all gone is an example of matter changing state. *)
  shows "∃x y z e1 e2. Pan x ∧ Water y ∧ State z ∧ Heating e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Gone e2 ∧ Agent e2 y ∧ ChangeState z"
proof -
  from asm have "Pan x ∧ Water y ∧ State z ∧ Heating e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Gone e2 ∧ Agent e2 y" by simp
  then have "Liquid y" using explanation_2 by blast
  then have "State y" using explanation_3 by blast
  then have "StateOfMatter y" using explanation_5 by blast
  then obtain e2 where e2: "ChangeState e2 ∧ Agent e2 y ∧ Patient e2 z" using explanation_1 by blast
  then have "DifferentState z" using explanation_4 by blast
  then have "StateOfMatter z" using explanation_6 by blast
  show ?thesis using asm e2 `StateOfMatter z` by blast
qed

end
