theory question_11_1

imports Main

begin

typedecl entity
typedecl event

consts
  Dangerous :: "event ⇒ bool"
  Safe :: "event ⇒ bool"
  Appliances :: "entity ⇒ bool"
  Outlet :: "entity ⇒ bool"
  Plugging :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Electricity :: "entity ⇒ bool"
  SafeAround :: "event ⇒ entity ⇒ bool"

(* Explanation 1: if an event is dangerous, it is not safe. *)
axiomatization where
  explanation_1: "∀e. Dangerous e ⟶ ¬Safe e"

(* Explanation 2: plugging many appliances into one outlet is dangerous. *)
axiomatization where
  explanation_2: "∀x y e. Appliances x ∧ Outlet y ∧ Plugging e ∧ Agent e x ∧ Patient e y ⟶ Dangerous e"  

theorem hypothesis:
  assumes asm: "Appliances x ∧ Outlet y ∧ Electricity z ∧ Plugging e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: Plugging many appliances into one outlet is not a way to stay safe around electricity. *)
  shows "¬SafeAround e z"
proof -
  from asm have "Appliances x ∧ Outlet y ∧ Plugging e ∧ Agent e x ∧ Patient e y" by simp
  then have "Dangerous e" using explanation_2 by blast
  then have "¬Safe e" using explanation_1 by blast
  then show ?thesis using asm `¬Safe e` by blast
qed

end
