theory question_63_2

imports Main

begin

typedecl entity
typedecl event

consts
  Rocks :: "entity ⇒ bool"
  Deposition :: "entity ⇒ bool"
  SedimentaryRocks :: "entity ⇒ bool"
  Formed :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Sandstone :: "entity ⇒ bool"

(* Explanation 1: Rocks are formed by deposition into sedimentary rocks. *)
axiomatization where
  explanation_1: "∀x y z e. Rocks x ∧ Deposition y ∧ SedimentaryRocks z ∧ Formed e ∧ Agent e x ∧ Patient e y ⟶ SedimentaryRocks z"

(* Explanation 2: Sandstone is a common type of sedimentary rock that is formed by deposition. *)
axiomatization where
  explanation_2: "∀x y z e. Sandstone x ∧ Deposition y ∧ SedimentaryRocks z ∧ Formed e ∧ Agent e x ∧ Patient e y ⟶ SedimentaryRocks z"  

theorem hypothesis:
  assumes asm: "Rocks x ∧ Deposition y ∧ Formed e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: Rocks formed by deposition are sandstone. *)
  shows "Sandstone x"
proof -
  from asm have "Rocks x ∧ Deposition y ∧ Formed e ∧ Agent e x ∧ Patient e y" by simp
  then have "SedimentaryRocks z" using explanation_1 by blast
  then have "Sandstone x" using explanation_2 by blast
  show ?thesis using `Sandstone x` by blast
qed

end
