theory question_20_8

imports Main

begin

typedecl entity

consts
  Fur :: "entity ⇒ bool"
  Feature :: "entity ⇒ bool"
  Mammals :: "entity ⇒ bool"
  Animals :: "entity ⇒ bool"
  FeatureOf :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Fur is a feature that is unique to and found in mammals. *)
axiomatization where
  explanation_1: "∀x. Fur x ⟶ Feature x ∧ Mammals x"

(* Explanation 2: No other animals except mammals have the feature of fur. *)
axiomatization where
  explanation_2: "∀x y. Animals x ∧ ¬Mammals x ∧ Fur y ⟶ ¬FeatureOf x y"  

theorem hypothesis:
  assumes asm: "Fur x"
  (* Hypothesis: Fur is unique to mammals. *)
  shows "Mammals x"
proof -
  from asm have "Fur x" by simp
  then have "Feature x ∧ Mammals x" using explanation_1 by blast
  then show ?thesis using `Mammals x` by blast
qed

end
