theory question_99_4
imports Main
begin

typedecl entity
typedecl event

consts
  VegetableOil :: "entity ⇒ bool"
  RenewableResource :: "entity ⇒ bool"
  Fuel :: "entity ⇒ bool"
  OrganicallyProduced :: "entity ⇒ bool"
  DieselEngine :: "entity ⇒ bool"
  MostRenewableFuelFor :: "entity ⇒ entity ⇒ entity ⇒ bool"
  Burn :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Vegetable oil is a renewable resource. *)
axiomatization where
  explanation_1: "∀x. VegetableOil x ⟶ RenewableResource x"

(* Explanation 2: Vegetable oil is a kind of fuel. *)
axiomatization where
  explanation_2: "∀x. VegetableOil x ⟶ Fuel x"

theorem hypothesis:
  (* Premise: Diesel engines can burn many kinds of fuel. *)
  assumes asm: "DieselEngine x ∧ Fuel y ∧ Burn x y"
  (* Hypothesis: Organically produced vegetable oil is the most renewable fuel for a diesel engine. *)
  shows "∃x y z e. OrganicallyProduced x ∧ VegetableOil y ∧ Fuel z ∧ DieselEngine e ∧ MostRenewableFuelFor x z e"
proof -
  from asm have "Fuel y" by simp
  then have "VegetableOil y" using explanation_2 by blast
  then have "RenewableResource y" using explanation_1 by blast
  then obtain x where x: "OrganicallyProduced x" by blast
  then obtain z where z: "Fuel z" by blast
  then obtain e where e: "DieselEngine e" by blast
  have conclusion: "MostRenewableFuelFor x z e" using x z e by simp
  show ?thesis using conclusion `VegetableOil y` by blast
qed

end
