theory question_39_0

imports Main

begin
typedecl entity
typedecl event

consts
  Play :: "event ⇒ bool"
  Playing :: "event ⇒ bool"
  Boys :: "entity ⇒ bool"
  Basketball :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Uniform :: "entity ⇒ (entity ⇒ bool) ⇒ bool"
  GreenWhite :: "entity ⇒ bool"
  BlueWhite :: "entity ⇒ bool"

(* Explanation 1: Play means the boys are playing. *)
axiomatization where
  explanation_1: "∀e. Play e ⟷ Playing e"

theorem hypothesis:
  (* Premise: Two boys in green and white uniforms play basketball with two boys in blue and white uniforms. *)
  assumes asm: "Boys x ∧ Boys y ∧ Uniform x GreenWhite ∧ Uniform y BlueWhite ∧ Play e ∧ Agent e x ∧ Patient e Basketball"
  (* Hypothesis: Boys are playing basketball. *)
  shows "∃x e. Boys x ∧ Basketball e ∧ Playing e ∧ Agent e x"
proof -
  from asm have "Boys x ∧ Basketball e ∧ Playing e ∧ Agent e x" by blast
  then show ?thesis using asm by blast
qed

end
