
## These are the basic configurations for running the different scripts (Teachers and Students).
**NB The OpenBookQA benchmark has been used as an example in this code. Moreover, we add some examples CoT-Demonstrations. In the final submission we will release adaptable code and CoT for all proposed benchmarks**


### Teacher mode
```bash
python Llama-2-70.py --dataset_path ./data/openbook_train.csv --token YOUR_HUGGINGFACE_CLI_TOKEN --mode CoT --teacher_mode
```

### Evaluation mode
```bash
python Llama-2-70.py --dataset_path ./data/openbook.csv --token YOUR_HUGGINGFACE_CLI_TOKEN --mode CoT
```
### Teacher mode
```bash
python GPT_3.5.py --dataset_path ./data/openbook_train.csv --api_key YOUR_OPENAI_API_KEY --mode CoT --teacher_mode
```

### Evaluation mode
```bash
python GPT_3.5.py --dataset_path ./data/openbook.csv --api_key YOUR_OPENAI_API_KEY --mode CoT 
```



### Student mode
```bash
python Llama-2-tuning_evaluation.py --action train --dataset_path ./data/openbookqa_CoT.csv --base_model_name meta-llama/Llama-2-7b --refined_model_path ./models
```

### Evaluation mode
```bash
python Llama-2-tuning_evaluation.py --action evaluate --dataset_path ./data/openbookqa.csv --base_model_name meta-llama/Llama-2-7b --refined_model_path ./models
```

### Student mode
```bash
python Mistral-7-tuning_evaluation.py --action train --dataset_path ./data/openbookqa_CoT.csv --base_model_name mistralai/Mistral-7B-v0.1 --refined_model_path ./models
```

### Evaluation mode
```bash
python Mistral-7-tuning_evaluation.py --action evaluate --dataset_path ./data/openbook.csv --base_model_name mistralai/Mistral-7B-v0.1 --refined_model_path ./model
```


Please run them in ./code path