import os
import json

def remove_attributes(data, attributes_to_remove):
    if isinstance(data, dict):
        for attribute in attributes_to_remove:
            data.pop(attribute, None)
        for key, value in data.items():
            remove_attributes(value, attributes_to_remove)
    elif isinstance(data, list):
        for item in data:
            remove_attributes(item, attributes_to_remove)

directory = './new'  # 替换为您的 "new" 目录的路径
attributes_to_remove = ['note start', 'note end', 'pace', 'range', 'singer']

for root, dirs, files in os.walk(directory):
    for filename in files:
        if filename.endswith('.json'):
            filepath = os.path.join(root, filename)
            with open(filepath, 'r') as file:
                data = json.load(file)
            
            remove_attributes(data, attributes_to_remove)
            
            with open(filepath, 'w') as file:
                json.dump(data, file, indent=4)