import re

def is_scientific_notation(s):
    
    pattern = r'^[+-]?(\d+(\.\d*)?|\.\d+)([eE][+-]?\d+)?$'
    return re.match(pattern, s) is not None


def is_percentage(s):
    
    pattern = r'^[+-]?(\d+(\.\d*)?|\.\d+)%$'
    return re.match(pattern, s) is not None


def is_currency(s):
    
    pattern = r'^[\$\€\£\¥]\d+(\.\d{1,2})?$'
    return bool(re.match(pattern, s))


def is_date(s):
       
    
    date_patterns = [
    r"\d{4}[-/]\d{1,2}[-/]\d{1,2}",  
    r"\d{1,2}[-/]\d{1,2}[-/]\d{4}",  
    r"\d{1,2}[-/]\d{1,2}",           
    r"\d{4}[-/]\d{1,2}"              
    ]
    
    combined_pattern = "(" + ")|(".join(date_patterns) + ")"
    
    match = re.match(combined_pattern, s)
    
    return bool(match)

def is_time(s):
    
    pattern = re.compile(r"^(2[0-3]|[01]?\d):([0-5]?\d)(\s?(AM|PM|am|pm))?$")
    return bool(pattern.match(s))

def is_fraction(s): 
    try:  
        parts = s.split('/')
        if len(parts) != 2:
            return False  
        numerator, denominator = map(int, parts)
        return denominator != 0
    except ValueError:
        return False

def check_ip(ip):
    def is_ipv4(ip):
        pattern = r'^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$'
        return re.match(pattern, ip)
    def is_ipv6(ip):
        pattern = r'^([\da-fA-F]{1,4}:){7}([\da-fA-F]{1,4})$'
        return re.match(pattern, ip)
    
    if is_ipv4(ip) or is_ipv6(ip):
        return True
  

def is_email(email):
    pattern = r'^[\w\.-]+@[\w\.-]+\.\w+$'
    return re.match(pattern, email)
