#!/bin/bash
GLOBIGNORE="*"
WORDPATH="./wordlists"
DATAPATH="./categories_nonprocessed"
TEMPTEXT="./wordlists/temp.txt"
ALPHALIST="./wordlists/wordlist_alphabetic.txt"

[ ! -d $WORDPATH ] && mkdir $WORDPATH
[ ! -f $TEMPTEXT ] && touch $TEMPTEXT
truncate -s 0 $TEMPTEXT

for DOMAIN in $(ls $DATAPATH)
do
    DOMAINPATH="${DATAPATH}/${DOMAIN}"
    echo "Working on ${DOMAIN}..."

    if [ -d $DOMAINPATH ]; then
        
        for FILE in $(ls $DOMAINPATH)
        do
            FILEPATH="${DOMAINPATH}/${FILE}"

            content=$(cat $FILEPATH)
            for word in $content:
            do
                echo "$word" >> $TEMPTEXT
            done
        done
    fi
done

cat $TEMPTEXT | tr '[A-Z]' '[a-z]'|\
                grep -ox -E '[abcdefghijklmnopqrstuvwxyz]+' |\
                sort | uniq > $ALPHALIST
echo "$ALPHALIST created."
