import os
import sys
import json
import argparse

sys.path.append("..")
from utils.logConfig import Log

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument('-i', type=str, default="vocab file", help='vocab file')
    parser.add_argument('-o', type=str, default="dict.txt", help='output file')
    parser.add_argument('-l', type=str, default="en", help='language')
    args = parser.parse_args()

    logger = Log.getLogger(os.path.basename(sys.argv[0]), "%s.log" % args.l)
    logger.info(args)

    with open(args.i, 'r') as fin, open(args.o, 'w') as fout:
        for line in fin:
            pieces = line.strip().split('\t')
            if pieces[0] not in  ['<unk>', '<s>', '</s>']:
                fout.write("{0} 1".format(pieces[0]) + '\n')
                fout.flush()
