#!/usr/bin/env bash

#!/usr/bin/env bash

cd ..

PREDICATE='UsedFor'
# SCORE_PARAM='perplexity'
# SCORE_PARAM='perplexity'


ALLSCORE=(
       'perplexity'
       'edge_plausible'
       'edge_salient'
       'edge_typical'
       'edge_remarkable'
       )

# BASE_FOLDER='EdgePrompts'
BASE_FOLDER='DICE'

for SCORE_PARAM in ${ALLSCORE[*]};
do

    python PromptFiltering/PercentileFilter.py \
        hydra.run.dir=/nas/home/qasemi/Mowgli-CoreQuisite/outputs/PercentileFilter/${BASE_FOLDER}/${PREDICATE}/${SCORE_PARAM}\
        hydra.verbose=false \
        prompts_path=/nas/home/qasemi/Mowgli-CoreQuisite/outputs/${BASE_FOLDER}/r/${PREDICATE}/Prompts.csv \
        score_param=${SCORE_PARAM} \
        output_prefix=${SCORE_PARAM} \
        sample_len=20

done

# python PromptFiltering/PercentileFilter.py \
#     hydra.run.dir=/nas/home/qasemi/Mowgli-CoreQuisite/outputs/PercentileFilter/${PREDICATE}/\
#     hydra.verbose=false \
#     prompts_path=/nas/home/qasemi/Mowgli-CoreQuisite/outputs/EdgePrompts/r/${PREDICATE}/Prompts.csv \
#     output_prefix='percentile' \
#     sample_len=20
