export CUDA_VISIBLE_DEVICES=0
export DATA_DIR=/home/LAB/chenty/workspace/public_dataset/CONLL2003
export TASK_NAME=QQP
export MODEL_PATH=/home/LAB/chenty/workspace/public_models/bert-tiny/bert-tiny.pt
export CONFIG_NAME=/home/LAB/chenty/workspace/public_models/bert-tiny/bert_config_relu.json
export OUTPUT_DIR=/home/LAB/chenty/workspace/personal/MSRA_project/encryption/unilm2-he/models/CONLL2003_relu
export STEPS=880

python nlu_finetune/run_ner.py \
  --config_name ${CONFIG_NAME} \
  --tokenizer_name unilm2-base-uncased \
  --model_name_or_path ${OUTPUT_DIR}/pytorch_model.bin \
  --task_name ${TASK_NAME} \
  --weight_decay 0.5 \
  --labels CONLL2003 \
  --do_train \
  --do_eval \
  --data_dir ${DATA_DIR} \
  --max_seq_length 128 \
  --per_gpu_train_batch_size 16 \
  --per_gpu_eval_batch_size 128 \
  --learning_rate 5e-5 \
  --num_train_epochs 8.0 \
  --save_steps ${STEPS} \
  --logging_steps ${STEPS} \
  --evaluate_during_training \
  --overwrite_output_dir \
  --output_dir ${OUTPUT_DIR} 
