import argparse

def get_params():
    # parse parameters
    parser = argparse.ArgumentParser(description="Cross-domain NER")
    parser.add_argument("--exp_name", type=str, default="default", help="Experiment name")
    parser.add_argument("--logger_filename", type=str, default="train.log")

    parser.add_argument("--dump_path", type=str, default="experiments", help="Experiment saved root path")
    parser.add_argument("--exp_id", type=str, default="1", help="Experiment id")

    parser.add_argument("--model_name", type=str, default="bert-base-cased", help="model name (e.g., bert-base-cased, roberta-base or wide_resnet)")
    parser.add_argument("--ckpt", type=str, default="", help="pretrain LM")
    parser.add_argument("--src_dm", type=str, default="conll2003", help="source domain")
    parser.add_argument("--tgt_dm", type=str, default="ai", help="target domain")

    parser.add_argument("--debug", default=False, action="store_true", help="if skipping the test on training and validation set")
    parser.add_argument("--test_pretrain", default=False, action="store_true", help="test on the pretrain model")
    parser.add_argument("--test_finetune", default=True, action="store_true", help="test on the finetune model")
    parser.add_argument("--path_pretrain", type=str, default='', help="path to load/save pretrain (source) model")
    parser.add_argument("--path_finetune", type=str, default='', help="path to load/save finetune model")

    parser.add_argument("--load_source_graph", default=False, action="store_true", help="load the source graph")
    parser.add_argument("--load_label_mapping", default=False, action="store_true", help="load the label mapping")

    # train parameters
    parser.add_argument("--epoch_target", type=int, default=0, help="Number of epoch in target domain")
    parser.add_argument("--batch_size_target", type=int, default=8, help="Batch size in target domain") 
    parser.add_argument("--lr_target", type=float, default=0.01, help="Learning rate")
    parser.add_argument("--schedule_source", type=str, default='(4, 7)', help="Multistep scheduler")
    parser.add_argument("--schedule_target", type=str, default='(30, 60)', help="Multistep scheduler")
    parser.add_argument("--gamma", type=float, default=0.2, help="Factor of the learning rate decay")
    parser.add_argument("--hidden_dim", type=int, default=768, help="Hidden layer dimension")

    parser.add_argument("--lambda_1",type=float, default=0.1, help="weight of sentence_bce_loss")
    parser.add_argument("--lambda_2",type=float, default=0.01, help="weight of graph_matching_loss")
    parser.add_argument("--temperature",type=float, default=4, help="temperature for the score of building graph")

    params = parser.parse_args()

    return params
