"""script for encoding the whole challenge"""
import subprocess
import os
import configargparse
parser = configargparse.ArgumentParser()
parser.add_argument('--challenge-path',
                    default='',
                    type=str,
                    help='path to the challenge directory')

parser.add_argument('--model-path',
                    default='',
                    type=str,
                    help='path to the spm model')

parser.add_argument('--dirs',
                    default=['dev-0', 'train', 'test-A', 'test-B'],
                    type=str,
                    help='names of the subdirectories in the challenge directory to be processed')

args = parser.parse_args()

all_path = args.challenge_path
model = args.model_path
dirs = args.dirs
for one_dir in dirs:
    for file in ['labels', 'articles', 'expected']:
        inf = f'{all_path}/{one_dir}/{file}.tsv'
        outf = f'{all_path}/{one_dir}/{file}-bpe.tsv'
        print(f'SentencePiecing file {inf}')
        if not os.path.exists(outf):
            if os.path.exists(inf):
                call_str = f'python spm_encode.py --model={model} < {inf} > {outf}'
                subprocess.call(call_str, shell=True)
            else:
                print(f'File does not exist {inf}')
        else:
            print(f'File exists {outf}')
