from audio_aug import *
import librosa
import soundfile as sf
from segment import AudioSegment

# 在没有引入AudioSegment前直接用data samples时传入
# augmentor = AudioAugmentor.from_config('aug_config/aug.yaml')
# fname = '../../../../samples/3170-137482-0010.wav'
# wav, curr_sample_rate = sf.read(fname)
# print("before perturb:", wav) #before perturb: [-0.00057983  0.0005188   0.006073   ... -0.00485229 -0.00814819 -0.00814819]
# wav = augmentor.perturb(wav)
# print("after perturb:", wav)
# sf.write('test_none.wav', wav, curr_sample_rate)


## process as segment, segment.samples 跟之前sf读取出来的wav是一样的
fname = '../../../../samples/3170-137482-0010.wav'
segment_audio = AudioSegment.from_file(fname)
augmentor = AudioAugmentor.from_config('aug_config/aug.yaml')
print("before perturb:", segment_audio.samples) # before perturb: [-0.00057983  0.0005188   0.006073   ... -0.00485229 -0.00814819 -0.00814819]
augmentor.perturb(segment_audio)
print("after perturb:", segment_audio.samples) # after perturb: [0.         0.         0.         ... 0.00500488 0.00857544 0.00564575] (shift)
sf.write('test.wav', segment_audio.samples, segment_audio.sample_rate)
