from allennlp.common import Params
import random
import myutils
random.seed(8446)

cmds = []
#for cut_frac in [.1,.2, .3]:
#for decay in [.35, .38, .5]:
for newSetup in [False, True]:
    for dataset in myutils.relTreebanks:
        dataset_config = Params.from_file('mtp/configs/ewt.json')
        dataset_config['UD']['train_data_path'] = '../newsplits-v2.7/' + dataset + '/train.conllu'
        dataset_config['UD']['validation_data_path'] = '../newsplits-v2.7/' + dataset + '/tune.conllu'
        if newSetup == False:
            dataset_config['UD']['train_data_path'] = '../newsplits-v2.7/' + dataset + '/trainPlusTune.conllu'
            dataset_config['UD']['validation_data_path'] = '../newsplits-v2.7/' + dataset + '/dev.conllu'
        if newSetup:
            dataset_config.to_file('configs/' + dataset + '.json')
        else:
            dataset_config.to_file('configs/' + dataset + '.oldSetup.json')
        for dropout in [.4, .2, .3]:
            for cut_frac in [.1,.2, .3]:
                for decay in [.35, .38, .5]:
                    base = Params.from_file('configs/params.json')
                    base['trainer']['learning_rate_scheduler']['decay_factor'] = decay
                    base['trainer']['learning_rate_scheduler']['cut_frac'] = cut_frac
                    base['model']['dropout'] = dropout
                    name = '.'.join([str(x).replace('.','') for x in [dropout, cut_frac, decay]])
                    if newSetup == False:
                        name += '.oldSetup'
                    model = myutils.getModel(dataset + '.' + name)
                    if model == '':
                        base.to_file('configs/params.' + name + '.json')
                        cmd = 'python3 train.py --name ' + dataset + '.' + name 
                        if newSetup:
                            cmd += ' --dataset_config ../configs/' + dataset + '.json'
                        else:
                            cmd += ' --dataset_config ../configs/' + dataset + '.oldSetup.json'
                        cmd += ' --parameters_config ../configs/params.' + name + '.json'
                        cmds.append(cmd)

# shuffle to make subsplits more likely to take evenly long
random.shuffle(cmds)
for cmd in cmds:
    print(cmd)


